/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class HiveCommitHandle
implements ConnectorCommitHandle {
    public static final HiveCommitHandle EMPTY_HIVE_COMMIT_HANDLE = new HiveCommitHandle((Map<SchemaTableName, List<DateTime>>)ImmutableMap.of());
    private final Map<SchemaTableName, List<DateTime>> lastDataCommitTimes;

    public HiveCommitHandle(Map<SchemaTableName, List<DateTime>> lastDataCommitTimes) {
        this.lastDataCommitTimes = Objects.requireNonNull(lastDataCommitTimes, "lastDataCommitTimes is null");
    }

    public String getSerializedCommitOutput(SchemaTableName table) {
        List commitTimes = (List)this.lastDataCommitTimes.getOrDefault(table, (List<DateTime>)ImmutableList.of()).stream().map(commitTime -> TimeUnit.MILLISECONDS.toSeconds(commitTime.getMillis())).collect(ImmutableList.toImmutableList());
        return Joiner.on((String)",").join((Iterable)commitTimes);
    }
}

