/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.glue;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.hive.aws.AbstractSdkMetricsCollector;
import com.facebook.presto.hive.metastore.glue.GlueCatalogApiStats;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class GlueMetastoreStats {
    private final GlueCatalogApiStats createDatabase = new GlueCatalogApiStats();
    private final GlueCatalogApiStats updateDatabase = new GlueCatalogApiStats();
    private final GlueCatalogApiStats deleteDatabase = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getDatabases = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getDatabase = new GlueCatalogApiStats();
    private final GlueCatalogApiStats createTable = new GlueCatalogApiStats();
    private final GlueCatalogApiStats updateTable = new GlueCatalogApiStats();
    private final GlueCatalogApiStats deleteTable = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getTables = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getTable = new GlueCatalogApiStats();
    private final GlueCatalogApiStats batchCreatePartitions = new GlueCatalogApiStats();
    private final GlueCatalogApiStats batchGetPartitions = new GlueCatalogApiStats();
    private final GlueCatalogApiStats updatePartition = new GlueCatalogApiStats();
    private final GlueCatalogApiStats deletePartition = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getPartitions = new GlueCatalogApiStats();
    private final GlueCatalogApiStats getPartition = new GlueCatalogApiStats();
    private final CounterStat awsRequestCount = new CounterStat();
    private final CounterStat awsRetryCount = new CounterStat();
    private final CounterStat awsThrottleExceptions = new CounterStat();
    private final TimeStat awsRequestTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientExecuteTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientRetryPauseTime = new TimeStat(TimeUnit.MILLISECONDS);

    @Managed
    @Nested
    public GlueCatalogApiStats getCreateDatabase() {
        return this.createDatabase;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getUpdateDatabase() {
        return this.updateDatabase;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getDeleteDatabase() {
        return this.deleteDatabase;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetDatabases() {
        return this.getDatabases;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetDatabase() {
        return this.getDatabase;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getCreateTable() {
        return this.createTable;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getUpdateTable() {
        return this.updateTable;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getDeleteTable() {
        return this.deleteTable;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetTables() {
        return this.getTables;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetTable() {
        return this.getTable;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getBatchCreatePartitions() {
        return this.batchCreatePartitions;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getBatchGetPartitions() {
        return this.batchGetPartitions;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getUpdatePartition() {
        return this.updatePartition;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getDeletePartition() {
        return this.deletePartition;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetPartitions() {
        return this.getPartitions;
    }

    @Managed
    @Nested
    public GlueCatalogApiStats getGetPartition() {
        return this.getPartition;
    }

    @Managed
    @Nested
    public CounterStat getAwsRequestCount() {
        return this.awsRequestCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsRetryCount() {
        return this.awsRetryCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsThrottleExceptions() {
        return this.awsThrottleExceptions;
    }

    @Managed
    @Nested
    public TimeStat getAwsRequestTime() {
        return this.awsRequestTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientExecuteTime() {
        return this.awsClientExecuteTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientRetryPauseTime() {
        return this.awsClientRetryPauseTime;
    }

    public GlueSdkClientMetricsCollector newRequestMetricsCollector() {
        return new GlueSdkClientMetricsCollector(this);
    }

    public static class GlueSdkClientMetricsCollector
    extends AbstractSdkMetricsCollector {
        private final GlueMetastoreStats stats;

        public GlueSdkClientMetricsCollector(GlueMetastoreStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        @Override
        protected void recordRequestCount(long count) {
            this.stats.awsRequestCount.update(count);
        }

        @Override
        protected void recordRetryCount(long count) {
            this.stats.awsRetryCount.update(count);
        }

        @Override
        protected void recordThrottleExceptionCount(long count) {
            this.stats.awsThrottleExceptions.update(count);
        }

        @Override
        protected void recordHttpRequestTime(Duration duration) {
            this.stats.awsRequestTime.add(duration);
        }

        @Override
        protected void recordClientExecutionTime(Duration duration) {
            this.stats.awsClientExecuteTime.add(duration);
        }

        @Override
        protected void recordRetryPauseTime(Duration duration) {
            this.stats.awsClientRetryPauseTime.add(duration);
        }
    }
}

