/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.transport.NetworkMessage;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TransportStatus;

public abstract class InboundMessage
extends NetworkMessage
implements Closeable {
    private final StreamInput streamInput;

    InboundMessage(ThreadContext threadContext, Version version, byte status, long requestId, StreamInput streamInput) {
        super(threadContext, version, status, requestId);
        this.streamInput = streamInput;
    }

    StreamInput getStreamInput() {
        return this.streamInput;
    }

    @Override
    public void close() throws IOException {
        this.streamInput.close();
    }

    private static void ensureVersionCompatibility(Version version, Version currentVersion, boolean isHandshake) {
        Version compatibilityVersion;
        Version version2 = compatibilityVersion = isHandshake ? currentVersion.minimumCompatibilityVersion() : currentVersion;
        if (!version.isCompatible(compatibilityVersion)) {
            Version minCompatibilityVersion = isHandshake ? compatibilityVersion : compatibilityVersion.minimumCompatibilityVersion();
            String msg = "Received " + (isHandshake ? "handshake " : "") + "message from unsupported version: [";
            throw new IllegalStateException(msg + version + "] minimal compatible version is: [" + minCompatibilityVersion + "]");
        }
    }

    public static class Response
    extends InboundMessage {
        Response(ThreadContext threadContext, Version version, byte status, long requestId, StreamInput streamInput) {
            super(threadContext, version, status, requestId, streamInput);
        }
    }

    public static class Request
    extends InboundMessage {
        private final String actionName;
        private final Set<String> features;

        Request(ThreadContext threadContext, Version version, byte status, long requestId, String actionName, Set<String> features, StreamInput streamInput) {
            super(threadContext, version, status, requestId, streamInput);
            this.actionName = actionName;
            this.features = features;
        }

        String getActionName() {
            return this.actionName;
        }

        Set<String> getFeatures() {
            return this.features;
        }
    }

    static class Reader {
        private final Version version;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final ThreadContext threadContext;

        Reader(Version version, NamedWriteableRegistry namedWriteableRegistry, ThreadContext threadContext) {
            this.version = version;
            this.namedWriteableRegistry = namedWriteableRegistry;
            this.threadContext = threadContext;
        }

        /*
         * Loose catch block
         */
        InboundMessage deserialize(BytesReference reference) throws IOException {
            Response response;
            ThreadContext.StoredContext existing;
            boolean success;
            StreamInput streamInput;
            block16: {
                InboundMessage message;
                streamInput = reference.streamInput();
                success = false;
                existing = this.threadContext.stashContext();
                long requestId = streamInput.readLong();
                byte status = streamInput.readByte();
                Version remoteVersion = Version.fromId(streamInput.readInt());
                boolean isHandshake = TransportStatus.isHandshake(status);
                InboundMessage.ensureVersionCompatibility(remoteVersion, this.version, isHandshake);
                if (remoteVersion.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
                    streamInput.readInt();
                } else {
                    streamInput = Reader.decompressingStream(status, remoteVersion, streamInput);
                }
                this.threadContext.readHeaders(streamInput);
                if (TransportStatus.isRequest(status)) {
                    String[] featuresFound;
                    Set<Object> features = remoteVersion.onOrAfter(Version.V_6_3_0) ? ((featuresFound = streamInput.readStringArray()).length == 0 ? Collections.emptySet() : Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(featuresFound)))) : Collections.emptySet();
                    String action = streamInput.readString();
                    if (remoteVersion.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
                        streamInput = Reader.decompressingStream(status, remoteVersion, streamInput);
                    }
                    streamInput = this.namedWriteableStream(streamInput, remoteVersion);
                    message = new Request(this.threadContext, remoteVersion, status, requestId, action, features, streamInput);
                } else {
                    if (remoteVersion.onOrAfter(TcpHeader.VERSION_WITH_HEADER_SIZE)) {
                        streamInput = Reader.decompressingStream(status, remoteVersion, streamInput);
                    }
                    streamInput = this.namedWriteableStream(streamInput, remoteVersion);
                    message = new Response(this.threadContext, remoteVersion, status, requestId, streamInput);
                }
                success = true;
                response = message;
                if (existing != null) {
                    existing.close();
                }
                if (success) break block16;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
            }
            return response;
            {
                catch (Throwable throwable) {
                    try {
                        if (existing != null) {
                            try {
                                existing.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
                        }
                        throw throwable3;
                    }
                }
            }
        }

        static StreamInput decompressingStream(byte status, Version remoteVersion, StreamInput streamInput) throws IOException {
            if (TransportStatus.isCompress(status) && streamInput.available() > 0) {
                try {
                    StreamInput decompressor = CompressorFactory.COMPRESSOR.streamInput(streamInput);
                    decompressor.setVersion(remoteVersion);
                    return decompressor;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("stream marked as compressed, but is missing deflate header");
                }
            }
            return streamInput;
        }

        private StreamInput namedWriteableStream(StreamInput delegate, Version remoteVersion) {
            NamedWriteableAwareStreamInput streamInput = new NamedWriteableAwareStreamInput(delegate, this.namedWriteableRegistry);
            streamInput.setVersion(remoteVersion);
            return streamInput;
        }
    }
}

