/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class GoogleCloudStorageExceptions {
    public static FileNotFoundException getFileNotFoundException(String bucketName, String objectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        return new FileNotFoundException(String.format("Item not found: '%s'. If you enabled STRICT generation consistency, it is possible that the live version is still available but the intended generation is deleted.", StorageResourceId.createReadableString(bucketName, Strings.nullToEmpty((String)objectName))));
    }

    public static IOException createCompositeException(Collection<IOException> innerExceptions) {
        Preconditions.checkArgument((innerExceptions != null && !innerExceptions.isEmpty() ? 1 : 0) != 0, (String)"innerExceptions (%s) must be not null and contain at least one element", innerExceptions);
        Iterator<IOException> innerExceptionIterator = innerExceptions.iterator();
        if (innerExceptions.size() == 1) {
            return innerExceptionIterator.next();
        }
        IOException combined = new IOException("Multiple IOExceptions.");
        while (innerExceptionIterator.hasNext()) {
            combined.addSuppressed(innerExceptionIterator.next());
        }
        return combined;
    }
}

