/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.PositionRecorder;
import com.facebook.hive.orc.PositionedOutputStream;
import com.facebook.hive.orc.RunLengthByteWriter;
import java.io.IOException;

class BitFieldWriter {
    private RunLengthByteWriter output;
    private final int bitSize;
    private byte current = 0;
    private int bitsLeft = 8;

    BitFieldWriter(PositionedOutputStream output, int bitSize) throws IOException {
        this.output = new RunLengthByteWriter(output);
        this.bitSize = bitSize;
    }

    private void writeByte() throws IOException {
        this.output.write(this.current);
        this.current = 0;
        this.bitsLeft = 8;
    }

    void flush() throws IOException {
        if (this.bitsLeft != 8) {
            this.writeByte();
        }
        this.output.flush();
    }

    void write(int value) throws IOException {
        int bitsToWrite = this.bitSize;
        while (bitsToWrite > this.bitsLeft) {
            this.current = (byte)(this.current | value >>> bitsToWrite - this.bitsLeft);
            value &= (1 << (bitsToWrite -= this.bitsLeft)) - 1;
            this.writeByte();
        }
        this.bitsLeft -= bitsToWrite;
        this.current = (byte)(this.current | value << this.bitsLeft);
        if (this.bitsLeft == 0) {
            this.writeByte();
        }
    }

    void getPosition(PositionRecorder recorder) throws IOException {
        this.output.getPosition(recorder);
        recorder.addPosition(8 - this.bitsLeft);
    }
}

