/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.dgc.VMID;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;
import org.apache.log4j.helpers.LogLog;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;

public class MiscUtil {
    private static final Log logger = LogFactory.getLog(MiscUtil.class);
    public static final String TOKEN_START = "%";
    public static final String TOKEN_END = "%";
    public static final String TOKEN_HOSTNAME = "hostname";
    public static final String TOKEN_APP_TYPE = "app-type";
    public static final String TOKEN_JVM_INSTANCE = "jvm-instance";
    public static final String TOKEN_TIME = "time:";
    public static final String TOKEN_PROPERTY = "property:";
    public static final String TOKEN_ENV = "env:";
    public static final String ESCAPE_STR = "\\";
    private static final VMID sJvmID = new VMID();
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Gson sGsonBuilder = null;
    private static String sApplicationType = null;
    private static UserGroupInformation ugiLoginUser = null;
    private static Subject subjectLoginUser = null;
    private static String local_hostname = null;
    private static Map<String, LogHistory> logHistoryList = new Hashtable<String, LogHistory>();
    private static int logInterval = 30000;

    public static String replaceTokens(String str, long time) {
        int tagEndPos;
        int tagStartPos;
        if (str == null) {
            return str;
        }
        if (time <= 0L) {
            time = System.currentTimeMillis();
        }
        int startPos = 0;
        while (startPos < str.length() && (tagStartPos = str.indexOf("%", startPos)) != -1 && (tagEndPos = str.indexOf("%", tagStartPos + "%".length())) != -1) {
            String tag = str.substring(tagStartPos, tagEndPos + "%".length());
            String token = tag.substring("%".length(), tag.lastIndexOf("%"));
            String val = "";
            if (token != null) {
                if (token.equals(TOKEN_HOSTNAME)) {
                    val = MiscUtil.getHostname();
                } else if (token.equals(TOKEN_APP_TYPE)) {
                    val = MiscUtil.getApplicationType();
                } else if (token.equals(TOKEN_JVM_INSTANCE)) {
                    val = MiscUtil.getJvmInstanceId();
                } else if (token.startsWith(TOKEN_PROPERTY)) {
                    String propertyName = token.substring(TOKEN_PROPERTY.length());
                    val = MiscUtil.getSystemProperty(propertyName);
                } else if (token.startsWith(TOKEN_ENV)) {
                    String envName = token.substring(TOKEN_ENV.length());
                    val = MiscUtil.getEnv(envName);
                } else if (token.startsWith(TOKEN_TIME)) {
                    String dtFormat = token.substring(TOKEN_TIME.length());
                    val = MiscUtil.getFormattedTime(time, dtFormat);
                }
            }
            if (val == null) {
                val = "";
            }
            str = str.substring(0, tagStartPos) + val + str.substring(tagEndPos + "%".length());
            startPos = tagStartPos + val.length();
        }
        return str;
    }

    public static String getHostname() {
        String ret = local_hostname;
        if (ret == null) {
            MiscUtil.initLocalHost();
            ret = local_hostname;
            if (ret == null) {
                ret = "unknown";
            }
        }
        return ret;
    }

    public static void setApplicationType(String applicationType) {
        sApplicationType = applicationType;
    }

    public static String getApplicationType() {
        return sApplicationType;
    }

    public static String getJvmInstanceId() {
        Integer val = sJvmID.toString().hashCode();
        long longVal = val.longValue();
        String ret = Long.toString(Math.abs(longVal));
        return ret;
    }

    public static String getSystemProperty(String propertyName) {
        String ret = null;
        try {
            ret = propertyName != null ? System.getProperty(propertyName) : null;
        }
        catch (Exception excp) {
            LogLog.warn((String)("getSystemProperty(" + propertyName + ") failed"), (Throwable)excp);
        }
        return ret;
    }

    public static String getEnv(String envName) {
        String ret = null;
        try {
            ret = envName != null ? System.getenv(envName) : null;
        }
        catch (Exception excp) {
            LogLog.warn((String)("getenv(" + envName + ") failed"), (Throwable)excp);
        }
        return ret;
    }

    public static String getFormattedTime(long time, String format) {
        String ret = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            ret = sdf.format(time);
        }
        catch (Exception excp) {
            LogLog.warn((String)("SimpleDateFormat.format() failed: " + format), (Throwable)excp);
        }
        return ret;
    }

    public static void createParents(File file) {
        File parentDir;
        String parentName;
        if (file != null && (parentName = file.getParent()) != null && !(parentDir = new File(parentName)).exists() && !parentDir.mkdirs()) {
            LogLog.warn((String)("createParents(): failed to create " + parentDir.getAbsolutePath()));
        }
    }

    public static long getNextRolloverTime(long lastRolloverTime, long interval) {
        long now = System.currentTimeMillis() / 1000L * 1000L;
        if (lastRolloverTime <= 0L) {
            return now + interval;
        }
        if (lastRolloverTime <= now) {
            long nextRolloverTime = now + interval;
            long trimInterval = (nextRolloverTime - lastRolloverTime) % interval;
            return nextRolloverTime - trimInterval;
        }
        return lastRolloverTime;
    }

    public static long getRolloverStartTime(long nextRolloverTime, long interval) {
        return nextRolloverTime <= interval ? System.currentTimeMillis() : nextRolloverTime - interval;
    }

    public static int parseInteger(String str, int defValue) {
        int ret = defValue;
        if (str != null) {
            try {
                ret = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String generateUniqueId() {
        return UUID.randomUUID().toString();
    }

    public static String generateGuid() {
        byte[] randomBytes = new byte[16];
        RandomHolder.random.nextBytes(randomBytes);
        UUID uuid = UUID.nameUUIDFromBytes(randomBytes);
        return uuid.toString();
    }

    public static <T> String stringify(T log) {
        String ret = null;
        if (log != null) {
            ret = log instanceof String ? (String)log : (sGsonBuilder != null ? sGsonBuilder.toJson(log) : log.toString());
        }
        return ret;
    }

    public static <T> T fromJson(String jsonStr, Class<T> clazz) {
        return (T)sGsonBuilder.fromJson(jsonStr, clazz);
    }

    public static String getStringProperty(Properties props, String propName) {
        String val;
        String ret = null;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = val;
        }
        return ret;
    }

    public static boolean getBooleanProperty(Properties props, String propName, boolean defValue) {
        String val;
        boolean ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            ret = Boolean.valueOf(val);
        }
        return ret;
    }

    public static int getIntProperty(Properties props, String propName, int defValue) {
        String val;
        int ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            try {
                ret = Integer.parseInt(val);
            }
            catch (NumberFormatException excp) {
                ret = defValue;
            }
        }
        return ret;
    }

    public static long getLongProperty(Properties props, String propName, long defValue) {
        String val;
        long ret = defValue;
        if (props != null && propName != null && (val = props.getProperty(propName)) != null) {
            try {
                ret = Long.parseLong(val);
            }
            catch (NumberFormatException excp) {
                ret = defValue;
            }
        }
        return ret;
    }

    public static Map<String, String> getPropertiesWithPrefix(Properties props, String prefix) {
        HashMap<String, String> prefixedProperties = new HashMap<String, String>();
        if (props != null && prefix != null) {
            for (String key : props.stringPropertyNames()) {
                if (key == null) continue;
                String val = props.getProperty(key);
                if (!key.startsWith(prefix) || (key = key.substring(prefix.length())) == null) continue;
                prefixedProperties.put(key, val);
            }
        }
        return prefixedProperties;
    }

    public static List<String> toArray(String destListStr, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (destListStr != null && !destListStr.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(destListStr, delim.trim());
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list;
    }

    public static String getCredentialString(String url, String alias) {
        if (url != null && alias != null) {
            return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
        }
        return null;
    }

    public static UserGroupInformation createUGIFromSubject(Subject subject) throws IOException {
        logger.info((Object)("SUBJECT " + (subject == null ? "not found" : "found")));
        UserGroupInformation ugi = null;
        if (subject != null) {
            logger.info((Object)("SUBJECT.PRINCIPALS.size()=" + subject.getPrincipals().size()));
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                logger.info((Object)("SUBJECT.PRINCIPAL.NAME=" + principal.getName()));
            }
            try {
                UserGroupInformation.getLoginUser();
                logger.info((Object)("Default UGI before using new Subject:" + UserGroupInformation.getLoginUser()));
            }
            catch (Throwable t) {
                logger.error((Object)t);
            }
            ugi = UserGroupInformation.getUGIFromSubject((Subject)subject);
            logger.info((Object)("SUBJECT.UGI.NAME=" + ugi.getUserName() + ", ugi=" + ugi));
        } else {
            logger.info((Object)"Server username is not available");
        }
        return ugi;
    }

    public static void setUGILoginUser(UserGroupInformation newUGI, Subject newSubject) {
        if (newUGI != null) {
            UserGroupInformation.setLoginUser((UserGroupInformation)newUGI);
            ugiLoginUser = newUGI;
            logger.info((Object)("Setting UGI=" + newUGI));
        } else {
            logger.error((Object)"UGI is null. Not setting it.");
        }
        if (newSubject != null) {
            logger.info((Object)"Setting SUBJECT");
            subjectLoginUser = newSubject;
        }
    }

    public static UserGroupInformation getUGILoginUser() {
        UserGroupInformation ret = ugiLoginUser;
        if (ret == null) {
            try {
                ret = MiscUtil.getLoginUser();
            }
            catch (IOException e) {
                logger.error((Object)"Error getting UGI.", (Throwable)e);
            }
        }
        if (ret != null) {
            try {
                ret.checkTGTAndReloginFromKeytab();
            }
            catch (IOException ioe) {
                logger.error((Object)"Error renewing TGT and relogin. Ignoring Exception, and continuing with the old TGT", (Throwable)ioe);
            }
        }
        return ret;
    }

    public static <X> X executePrivilegedAction(PrivilegedExceptionAction<X> action) throws Exception {
        UserGroupInformation ugi = MiscUtil.getUGILoginUser();
        if (ugi != null) {
            return (X)ugi.doAs(action);
        }
        return action.run();
    }

    public static <X> X executePrivilegedAction(PrivilegedAction<X> action) {
        UserGroupInformation ugi = MiscUtil.getUGILoginUser();
        if (ugi != null) {
            return (X)ugi.doAs(action);
        }
        return action.run();
    }

    public static Subject getSubjectLoginUser() {
        return subjectLoginUser;
    }

    public static String getKerberosNamesRules() {
        return KerberosName.getRules();
    }

    public static String getShortNameFromPrincipalName(String principal) {
        if (principal == null) {
            return null;
        }
        try {
            KerberosName kerbrosName = new KerberosName(principal);
            String userName = kerbrosName.getShortName();
            userName = StringUtils.substringBefore((String)userName, (String)"/");
            userName = StringUtils.substringBefore((String)userName, (String)"@");
            return userName;
        }
        catch (Throwable t) {
            logger.error((Object)("Error converting kerberos name. principal=" + principal + ", KerberosName.rules=" + KerberosName.getRules()));
            return principal;
        }
    }

    public static Set<String> getGroupsForRequestUser(String userName) {
        if (userName != null) {
            try {
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)userName);
                String[] groups = ugi.getGroupNames();
                if (groups != null && groups.length > 0) {
                    HashSet<String> groupsSet = new HashSet<String>();
                    for (String group : groups) {
                        groupsSet.add(group);
                    }
                    return groupsSet;
                }
            }
            catch (Throwable e) {
                MiscUtil.logErrorMessageByInterval(logger, "Error getting groups for users. userName=" + userName, e);
            }
        }
        return Collections.emptySet();
    }

    public static boolean logErrorMessageByInterval(Log useLogger, String message) {
        return MiscUtil.logErrorMessageByInterval(useLogger, message, null);
    }

    public static boolean logErrorMessageByInterval(Log useLogger, String message, Throwable e) {
        if (message == null) {
            return false;
        }
        LogHistory log = logHistoryList.get(message);
        if (log == null) {
            log = new LogHistory();
            logHistoryList.put(message, log);
        }
        if (System.currentTimeMillis() - log.lastLogTime > (long)logInterval) {
            log.lastLogTime = System.currentTimeMillis();
            int counter = log.counter;
            log.counter = 0;
            if (counter > 0) {
                message = message + ". Messages suppressed before: " + counter;
            }
            if (e == null) {
                useLogger.error((Object)message);
            } else {
                useLogger.error((Object)message, e);
            }
            return true;
        }
        ++log.counter;
        return false;
    }

    public static void setUGIFromJAASConfig(String jaasConfigAppName) throws Exception {
        String keytabFile = null;
        String principal = null;
        UserGroupInformation ugi = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("===> MiscUtil.setUGIFromJAASConfig() jaasConfigAppName: " + jaasConfigAppName));
        }
        try {
            Object[] entries = Configuration.getConfiguration().getAppConfigurationEntry(jaasConfigAppName);
            if (!ArrayUtils.isEmpty((Object[])entries)) {
                for (Object entry : entries) {
                    if (((AppConfigurationEntry)entry).getOptions().get("keyTab") != null) {
                        keytabFile = (String)((AppConfigurationEntry)entry).getOptions().get("keyTab");
                    }
                    if (((AppConfigurationEntry)entry).getOptions().get("principal") != null) {
                        principal = (String)((AppConfigurationEntry)entry).getOptions().get("principal");
                    }
                    if (!StringUtils.isEmpty(principal) && !StringUtils.isEmpty((String)keytabFile)) break;
                }
                if (StringUtils.isEmpty(principal) || StringUtils.isEmpty(keytabFile)) {
                    String error_mesage = "Unable to get the principal/keytab from jaasConfigAppName: " + jaasConfigAppName;
                    logger.error((Object)error_mesage);
                    throw new Exception(error_mesage);
                }
                UserGroupInformation.loginUserFromKeytab(principal, keytabFile);
                ugi = UserGroupInformation.getLoginUser();
                logger.info((Object)("MiscUtil.setUGIFromJAASConfig() UGI: " + ugi + " principal: " + principal + " keytab: " + keytabFile));
            } else {
                logger.warn((Object)"JAASConfig file not found! Ranger Plugin will not working in a Secure Cluster...");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to set UGI for Principal: " + principal + " keytab: " + keytabFile));
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<=== MiscUtil.setUGIFromJAASConfig() jaasConfigAppName: " + jaasConfigAppName + " UGI: " + ugi + " principal: " + principal + " keytab: " + keytabFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void authWithKerberos(String keytab, String principal, String nameRules) {
        block18: {
            if (keytab == null || principal == null) {
                return;
            }
            Subject serverSubject = new Subject();
            int successLoginCount = 0;
            String[] spnegoPrincipals = null;
            try {
                boolean useKeytab;
                if (principal.equals("*")) {
                    spnegoPrincipals = KerberosUtil.getPrincipalNames((String)keytab, (Pattern)Pattern.compile("HTTP/.*"));
                    if (spnegoPrincipals.length == 0) {
                        logger.error((Object)("No principals found in keytab=" + keytab));
                    }
                } else {
                    spnegoPrincipals = new String[]{principal};
                }
                if (nameRules != null) {
                    KerberosName.setRules((String)nameRules);
                }
                if (!(useKeytab = true)) {
                    logger.info((Object)"Creating UGI with subject");
                    LoginContext loginContext = null;
                    ArrayList<LoginContext> loginContexts = new ArrayList<LoginContext>();
                    for (String spnegoPrincipal : spnegoPrincipals) {
                        try {
                            logger.info((Object)("Login using keytab " + keytab + ", for principal " + spnegoPrincipal));
                            KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(keytab, spnegoPrincipal);
                            loginContext = new LoginContext("", serverSubject, null, kerberosConfiguration);
                            loginContext.login();
                            ++successLoginCount;
                            logger.info((Object)("Login success keytab " + keytab + ", for principal " + spnegoPrincipal));
                            loginContexts.add(loginContext);
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Login failed keytab " + keytab + ", for principal " + spnegoPrincipal), t);
                        }
                        if (successLoginCount > 0) {
                            logger.info((Object)("Total login success count=" + successLoginCount));
                            try {
                                UserGroupInformation.loginUserFromSubject((Subject)serverSubject);
                                continue;
                            }
                            catch (Throwable e) {
                                logger.error((Object)("Error creating UGI from subject. subject=" + serverSubject));
                                continue;
                            }
                            finally {
                                if (loginContext != null) {
                                    loginContext.logout();
                                }
                            }
                        }
                        logger.error((Object)("Total logins were successfull from keytab=" + keytab + ", principal=" + principal));
                    }
                    break block18;
                }
                logger.info((Object)("Creating UGI from keytab directly. keytab=" + keytab + ", principal=" + spnegoPrincipals[0]));
                UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)spnegoPrincipals[0], (String)keytab);
                MiscUtil.setUGILoginUser(ugi, null);
            }
            catch (Throwable t) {
                logger.error((Object)"Failed to login with given keytab and principal", t);
            }
        }
    }

    public static UserGroupInformation getLoginUser() throws IOException {
        return UserGroupInformation.getLoginUser();
    }

    private static void initLocalHost() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> MiscUtil.initLocalHost()");
        }
        try {
            local_hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable excp) {
            LogLog.warn((String)"getHostname()", (Throwable)excp);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== MiscUtil.initLocalHost()");
        }
    }

    public static Date getUTCDateForLocalDate(Date date) {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+0");
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(date.getTime());
        utc.add(14, -offset);
        return utc.getTime();
    }

    public static Date getUTCDate() {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+0");
        Calendar local = Calendar.getInstance();
        int offset = local.getTimeZone().getOffset(local.getTimeInMillis());
        GregorianCalendar utc = new GregorianCalendar(gmtTimeZone);
        utc.setTimeInMillis(local.getTimeInMillis());
        utc.add(14, -offset);
        return utc.getTime();
    }

    static {
        try {
            sGsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").create();
        }
        catch (Throwable excp) {
            LogLog.warn((String)"failed to create GsonBuilder object. stringify() will return obj.toString(), instead of Json", (Throwable)excp);
        }
        MiscUtil.initLocalHost();
    }

    private static class RandomHolder {
        static final Random random = new Random();

        private RandomHolder() {
        }
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;

        public KerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (PlatformName.IBM_JAVA) {
                options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
                options.put("principal", this.principal);
                options.put("credsType", "acceptor");
            } else {
                options.put("keyTab", this.keytab);
                options.put("principal", this.principal);
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("useTicketCache", "true");
                options.put("renewTGT", "true");
                options.put("isInitiator", "false");
            }
            options.put("refreshKrb5Config", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                if (PlatformName.IBM_JAVA) {
                    options.put("useDefaultCcache", "true");
                    System.setProperty("KRB5CCNAME", ticketCache);
                    options.put("renewTGT", "true");
                    options.put("credsType", "both");
                } else {
                    options.put("ticketCache", ticketCache);
                }
            }
            if (logger.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    static class LogHistory {
        long lastLogTime = 0L;
        int counter = 0;

        LogHistory() {
        }
    }
}

