/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerNoneOfExpectedTagsPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerNoneOfExpectedTagsPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerNoneOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + ")"));
        }
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerNoneOfExpectedTagsPresentConditionEvaluator.init(" + this.condition + "): Tags[" + this.policyConditionTags + "]"));
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerNoneOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + ")"));
        }
        boolean matched = true;
        RangerAccessRequest readOnlyRequest = request.getReadOnlyCopy();
        RangerScriptExecutionContext context = new RangerScriptExecutionContext(readOnlyRequest);
        Set<String> resourceTags = context.getAllTagTypes();
        if (resourceTags != null) {
            matched = Collections.disjoint(resourceTags, this.policyConditionTags);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerNoneOfExpectedTagsPresentConditionEvaluator.isMatched(" + request + "): " + matched));
        }
        return matched;
    }
}

