/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.RoleStore;

public class RangerRoleValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerRoleValidator.class);

    public RangerRoleValidator(RoleStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerRole rangeRole, RangerValidator.Action action) throws Exception {
        String message;
        boolean valid;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerRoleValidator.validate(%s, %s)", new Object[]{rangeRole, action}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(rangeRole, action, failures);
            message = "";
            try {
                if (valid) break block5;
                message = RangerRoleValidator.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerRoleValidator.validate(%s, %s): %s, reason[%s]", new Object[]{rangeRole, action, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerRoleValidator.validate(%s, %s): %s, reason[%s]", new Object[]{rangeRole, action, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerRoleValidator.isValid(%s, %s, %s)", new Object[]{id, action, failures}));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("Role id was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            valid = false;
        } else if (!this.roleExists(id)) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_INVALID_ROLE_ID;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("Role with id[{0}] does not exist").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            valid = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerRoleValidator.isValid(%s, %s, %s): %s", new Object[]{id, action, failures, valid}));
        }
        return valid;
    }

    @Override
    boolean isValid(String name, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerRoleValidator.isValid(%s, %s, %s)", new Object[]{name, action, failures}));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else if (name == null) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("Role name was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
            valid = false;
        } else if (!this.roleExists(name)) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_INVALID_ROLE_NAME;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("Role with name[{0}] does not exist").field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
            valid = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerRoleValidator.isValid(%s, %s, %s): %s", new Object[]{name, action, failures, valid}));
        }
        return valid;
    }

    boolean isValid(RangerRole rangerRole, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerRoleValidator.isValid(%s, %s, %s)", new Object[]{rangerRole, action, failures}));
        }
        boolean valid = true;
        if (rangerRole == null) {
            ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_NULL_RANGER_ROLE_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else {
            String roleName = rangerRole.getName();
            if (StringUtils.isEmpty((String)roleName)) {
                ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_NULL_RANGER_ROLE_NAME;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                valid = false;
            }
            Long id = rangerRole.getId();
            RangerRole existingRangerRole = null;
            if (null != id) {
                existingRangerRole = this.getRangerRole(id);
            }
            if (action == RangerValidator.Action.CREATE) {
                String existingRoleName;
                if (existingRangerRole != null && roleName.equals(existingRoleName = existingRangerRole.getName())) {
                    ValidationErrorCode error = ValidationErrorCode.ROLE_VALIDATION_ERR_ROLE_NAME_CONFLICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("name").isSemanticallyIncorrect().becauseOf(error.getMessage(existingRoleName)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
            } else if (action == RangerValidator.Action.UPDATE) {
                ValidationErrorCode error;
                if (id == null) {
                    error = ValidationErrorCode.ROLE_VALIDATION_ERR_MISSING_FIELD;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().becauseOf(error.getMessage(id)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                if (existingRangerRole == null) {
                    error = ValidationErrorCode.ROLE_VALIDATION_ERR_INVALID_ROLE_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().becauseOf(error.getMessage(id)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerRoleValidator.isValid(%s, %s, %s): %s", new Object[]{rangerRole, action, failures, valid}));
        }
        return valid;
    }
}

