/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerZoneResourceMatcher;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.store.EmbeddedServiceDefsUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;

public class PolicyEngine {
    private static final Log LOG = LogFactory.getLog(PolicyEngine.class);
    private static final Log PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private static final Log PERF_POLICYENGINE_REBALANCE_LOG = RangerPerfTracer.getPerfLogger("policyengine.rebalance");
    private final RangerPolicyRepository policyRepository;
    private final RangerPolicyRepository tagPolicyRepository;
    private final List<RangerContextEnricher> allContextEnrichers;
    private final RangerPluginContext pluginContext;
    private final Map<String, RangerPolicyRepository> zonePolicyRepositories = new HashMap<String, RangerPolicyRepository>();
    private final Map<String, RangerResourceTrie> resourceZoneTrie = new HashMap<String, RangerResourceTrie>();
    private final Map<String, String> zoneTagServiceMap = new HashMap<String, String>();
    private boolean useForwardedIPAddress;
    private String[] trustedProxyAddresses;

    public boolean getUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.useForwardedIPAddress = useForwardedIPAddress;
    }

    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.trustedProxyAddresses = trustedProxyAddresses;
    }

    public long getRoleVersion() {
        return this.pluginContext.getAuthContext().getRoleVersion();
    }

    public void setRoles(RangerRoles roles) {
        this.pluginContext.getAuthContext().setRoles(roles);
    }

    public String getServiceName() {
        return this.policyRepository.getServiceName();
    }

    public RangerServiceDef getServiceDef() {
        return this.policyRepository.getServiceDef();
    }

    public long getPolicyVersion() {
        return this.policyRepository.getPolicyVersion();
    }

    public RangerPolicyRepository getPolicyRepository() {
        return this.policyRepository;
    }

    public RangerPolicyRepository getTagPolicyRepository() {
        return this.tagPolicyRepository;
    }

    public Map<String, RangerPolicyRepository> getZonePolicyRepositories() {
        return this.zonePolicyRepositories;
    }

    public List<RangerContextEnricher> getAllContextEnrichers() {
        return this.allContextEnrichers;
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("PolicyEngine={");
        sb.append("serviceName={").append(this.getServiceName()).append("} ");
        sb.append("policyRepository={");
        if (this.policyRepository != null) {
            this.policyRepository.toString(sb);
        }
        sb.append("} ");
        sb.append("tagPolicyRepository={");
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        RangerPolicyRepository zoneResourceRepository = this.zonePolicyRepositories.get(zoneName);
        return zoneResourceRepository == null ? ListUtils.EMPTY_LIST : zoneResourceRepository.getPolicies();
    }

    Map<String, RangerResourceTrie> getResourceZoneTrie() {
        return this.resourceZoneTrie;
    }

    public PolicyEngine(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles) {
        List<RangerContextEnricher> tmpList;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyEngine(, " + servicePolicies + ", " + pluginContext + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.init(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        this.pluginContext = pluginContext;
        this.pluginContext.setAuthContext(new RangerAuthContext(null, roles));
        RangerPolicyEngineOptions options = pluginContext.getConfig().getPolicyEngineOptions();
        if (StringUtils.isBlank((String)options.evaluatorType) || StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"auto")) {
            options.evaluatorType = "optimized";
        }
        this.policyRepository = new RangerPolicyRepository(servicePolicies, this.pluginContext);
        ServicePolicies.TagPolicies tagPolicies = servicePolicies.getTagPolicies();
        if (!(options.disableTagPolicyEvaluation || tagPolicies == null || StringUtils.isEmpty((String)tagPolicies.getServiceName()) || tagPolicies.getServiceDef() == null || CollectionUtils.isEmpty(tagPolicies.getPolicies()))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PolicyEngine : Building tag-policy-repository for tag-service " + tagPolicies.getServiceName()));
            }
            this.tagPolicyRepository = new RangerPolicyRepository(tagPolicies, this.pluginContext, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("PolicyEngine : No tag-policy-repository for service " + servicePolicies.getServiceName()));
            }
            this.tagPolicyRepository = null;
        }
        List<RangerContextEnricher> tagContextEnrichers = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(tagContextEnrichers)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = tagContextEnrichers;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(tagContextEnrichers);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            this.buildZoneTrie(servicePolicies);
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> zone : servicePolicies.getSecurityZones().entrySet()) {
                RangerPolicyRepository policyRepository = new RangerPolicyRepository(servicePolicies, this.pluginContext, zone.getKey());
                this.zonePolicyRepositories.put(zone.getKey(), policyRepository);
            }
        }
        RangerPerfTracer.log(perf);
        if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug((Object)("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyEngine()");
        }
    }

    public PolicyEngine cloneWithDelta(ServicePolicies servicePolicies) {
        RangerServiceDef serviceDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cloneWithDelta()");
        }
        String serviceType = (serviceDef = this.getServiceDef()) != null ? serviceDef.getName() : "";
        boolean isValidDeltas = false;
        if (CollectionUtils.isNotEmpty(servicePolicies.getPolicyDeltas()) || MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            boolean bl = isValidDeltas = CollectionUtils.isEmpty(servicePolicies.getPolicyDeltas()) || RangerPolicyDeltaUtil.isValidDeltas(servicePolicies.getPolicyDeltas(), serviceType);
            if (isValidDeltas && MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
                for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> entry : servicePolicies.getSecurityZones().entrySet()) {
                    if (RangerPolicyDeltaUtil.isValidDeltas(entry.getValue().getPolicyDeltas(), serviceType)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Invalid policy-deltas for security zone:[" + entry.getKey() + "]"));
                    }
                    isValidDeltas = false;
                    break;
                }
            }
        }
        PolicyEngine ret = isValidDeltas ? new PolicyEngine(this, servicePolicies) : null;
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")"));
        }
        return ret;
    }

    public RangerPolicyRepository getRepositoryForMatchedZone(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyEngine.getRepositoryForMatchedZone(" + policy + ")"));
        }
        String zoneName = policy.getZoneName();
        RangerPolicyRepository ret = this.getRepositoryForZone(zoneName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyEngine.getRepositoryForMatchedZone(" + policy + ")"));
        }
        return ret;
    }

    public Set<String> getMatchedZonesForResourceAndChildren(RangerAccessResource accessResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyEngine.getMatchedZonesForResourceAndChildren(" + accessResource + ")"));
        }
        Set<String> ret = null;
        if (MapUtils.isNotEmpty(this.resourceZoneTrie)) {
            ret = this.getMatchedZonesForResourceAndChildren(accessResource.getAsMap(), accessResource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyEngine.getMatchedZonesForResourceAndChildren(" + accessResource + ") : " + ret));
        }
        return ret;
    }

    public String getUniquelyMatchedZoneName(Map<String, ?> resourceAsMap) {
        String ret = null;
        Set<String> matchedZones = this.getMatchedZonesForResourceAndChildren(resourceAsMap, this.convertToAccessResource(resourceAsMap));
        if (CollectionUtils.isNotEmpty(matchedZones) && matchedZones.size() == 1) {
            String[] matchedZonesArray = new String[1];
            matchedZones.toArray(matchedZonesArray);
            ret = matchedZonesArray[0];
        }
        return ret;
    }

    public RangerPolicyRepository getRepositoryForZone(String zoneName) {
        RangerPolicyRepository ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if ((ret = StringUtils.isNotEmpty((String)zoneName) ? this.getZonePolicyRepositories().get(zoneName) : this.getPolicyRepository()) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        }
        return ret;
    }

    public boolean hasTagPolicies(RangerPolicyRepository tagPolicyRepository) {
        return tagPolicyRepository != null && CollectionUtils.isNotEmpty(tagPolicyRepository.getPolicies());
    }

    public boolean hasResourcePolicies(RangerPolicyRepository policyRepository) {
        return policyRepository != null && CollectionUtils.isNotEmpty(policyRepository.getPolicies());
    }

    public boolean isResourceZoneAssociatedWithTagService(String resourceZoneName) {
        boolean ret;
        if (StringUtils.isNotEmpty((String)resourceZoneName) && this.tagPolicyRepository != null && this.zoneTagServiceMap.get(resourceZoneName) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Accessed resource is in a zone:[" + resourceZoneName + "] which is associated with the tag-service:[" + this.tagPolicyRepository.getServiceName() + "]"));
            }
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public void preCleanup(boolean isForced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyEngine.preCleanup(isForced=" + isForced + ")"));
        }
        if (this.policyRepository != null) {
            this.policyRepository.preCleanup(isForced);
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.preCleanup(isForced);
        }
        if (MapUtils.isNotEmpty(this.zonePolicyRepositories)) {
            for (Map.Entry<String, RangerPolicyRepository> entry : this.zonePolicyRepositories.entrySet()) {
                entry.getValue().preCleanup(isForced);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyEngine.preCleanup(isForced=" + isForced + ")"));
        }
    }

    private Set<String> getMatchedZonesForResourceAndChildren(Map<String, ?> resource, RangerAccessResource accessResource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyEngine.getMatchedZonesForResourceAndChildren(" + resource + ", " + accessResource + ")"));
        }
        HashSet<String> ret = null;
        if (MapUtils.isNotEmpty(this.resourceZoneTrie)) {
            ArrayList zoneMatchersList = null;
            Set<Object> smallestList = null;
            for (Map.Entry<String, ?> entry : resource.entrySet()) {
                String string = entry.getKey();
                Object resourceValues = entry.getValue();
                RangerResourceTrie trie = this.resourceZoneTrie.get(string);
                if (trie == null) continue;
                Set matchedZones = trie.getEvaluatorsForResource(resourceValues);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ResourceDefName:[" + string + "], values:[" + resourceValues + "], matched-zones:[" + matchedZones + "]"));
                }
                if (CollectionUtils.isEmpty(matchedZones)) {
                    zoneMatchersList = null;
                    smallestList = null;
                    break;
                }
                if (smallestList == null) {
                    smallestList = matchedZones;
                    continue;
                }
                if (zoneMatchersList == null) {
                    zoneMatchersList = new ArrayList();
                    zoneMatchersList.add(smallestList);
                }
                zoneMatchersList.add(matchedZones);
                if (smallestList.size() <= matchedZones.size()) continue;
                smallestList = matchedZones;
            }
            if (smallestList != null) {
                HashSet intersection;
                if (zoneMatchersList != null) {
                    intersection = new HashSet(smallestList);
                    for (Set set : zoneMatchersList) {
                        if (set == smallestList) continue;
                        intersection.retainAll(set);
                        if (!CollectionUtils.isEmpty(intersection)) continue;
                        break;
                    }
                } else {
                    intersection = smallestList;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Resource:[" + resource + "], matched-zones:[" + intersection + "]"));
                }
                if (intersection.size() > 0) {
                    ret = new HashSet<String>();
                    for (RangerZoneResourceMatcher rangerZoneResourceMatcher : intersection) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Trying to match resource:[" + accessResource + "] using zoneMatcher:[" + rangerZoneResourceMatcher + "]"));
                        }
                        if (rangerZoneResourceMatcher.getPolicyResourceMatcher().isMatch(accessResource, RangerPolicyResourceMatcher.MatchScope.ANY, null)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Matched resource:[" + accessResource + "] using zoneMatcher:[" + rangerZoneResourceMatcher + "]"));
                            }
                            ret.add(rangerZoneResourceMatcher.getSecurityZoneName());
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Did not match resource:[" + accessResource + "] using zoneMatcher:[" + rangerZoneResourceMatcher + "]"));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The following zone-names matched resource:[" + accessResource + "]: " + ret));
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyEngine.getMatchedZonesForResourceAndChildren(" + resource + ", " + accessResource + ") : " + ret));
        }
        return ret;
    }

    private RangerAccessResource convertToAccessResource(Map<String, ?> resource) {
        RangerAccessResourceImpl ret = new RangerAccessResourceImpl();
        ret.setServiceDef(this.getServiceDef());
        for (Map.Entry<String, ?> entry : resource.entrySet()) {
            ret.setValue(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private PolicyEngine(PolicyEngine other, ServicePolicies servicePolicies) {
        List<RangerContextEnricher> tmpList;
        this.useForwardedIPAddress = other.useForwardedIPAddress;
        this.trustedProxyAddresses = other.trustedProxyAddresses;
        this.pluginContext = other.pluginContext;
        long policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        ArrayList<RangerPolicyDelta> defaultZoneDeltas = new ArrayList<RangerPolicyDelta>();
        ArrayList<RangerPolicyDelta> defaultZoneDeltasForTagPolicies = new ArrayList<RangerPolicyDelta>();
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            this.buildZoneTrie(servicePolicies);
            HashMap<String, ArrayList<RangerPolicyDelta>> zoneDeltasMap = new HashMap<String, ArrayList<RangerPolicyDelta>>();
            for (Map.Entry entry : servicePolicies.getSecurityZones().entrySet()) {
                List<RangerPolicyDelta> deltas = ((ServicePolicies.SecurityZoneInfo)entry.getValue()).getPolicyDeltas();
                for (RangerPolicyDelta delta : deltas) {
                    String zoneName = delta.getZoneName();
                    if (StringUtils.isNotEmpty((String)zoneName)) {
                        ArrayList<RangerPolicyDelta> zoneDeltas = (ArrayList<RangerPolicyDelta>)zoneDeltasMap.get(zoneName);
                        if (zoneDeltas == null) {
                            zoneDeltas = new ArrayList<RangerPolicyDelta>();
                            zoneDeltasMap.put(zoneName, zoneDeltas);
                        }
                        zoneDeltas.add(delta);
                        continue;
                    }
                    LOG.warn((Object)("policyDelta : [" + delta + "] does not belong to any zone. Should not have come here."));
                }
            }
            for (Map.Entry entry : zoneDeltasMap.entrySet()) {
                RangerPolicyRepository policyRepository;
                String zoneName = (String)entry.getKey();
                List zoneDeltas = (List)entry.getValue();
                RangerPolicyRepository otherRepository = other.zonePolicyRepositories.get(zoneName);
                if (CollectionUtils.isNotEmpty((Collection)zoneDeltas)) {
                    if (otherRepository == null) {
                        ArrayList<RangerPolicy> policies = new ArrayList<RangerPolicy>();
                        for (RangerPolicyDelta delta : zoneDeltas) {
                            if (delta.getChangeType() == 0) {
                                policies.add(delta.getPolicy());
                                continue;
                            }
                            LOG.warn((Object)("Expected changeType:[0], found policy-change-delta:[" + delta + "]"));
                        }
                        servicePolicies.getSecurityZones().get(zoneName).setPolicies(policies);
                        policyRepository = new RangerPolicyRepository(servicePolicies, this.pluginContext, zoneName);
                    } else {
                        policyRepository = new RangerPolicyRepository(otherRepository, zoneDeltas, policyVersion);
                    }
                } else {
                    policyRepository = this.shareWith(otherRepository);
                }
                this.zonePolicyRepositories.put(zoneName, policyRepository);
            }
        }
        List<RangerPolicyDelta> unzonedDeltas = servicePolicies.getPolicyDeltas();
        for (RangerPolicyDelta rangerPolicyDelta : unzonedDeltas) {
            if (servicePolicies.getServiceDef().getName().equals(rangerPolicyDelta.getServiceType())) {
                defaultZoneDeltas.add(rangerPolicyDelta);
                continue;
            }
            defaultZoneDeltasForTagPolicies.add(rangerPolicyDelta);
        }
        this.policyRepository = other.policyRepository != null && CollectionUtils.isNotEmpty(defaultZoneDeltas) ? new RangerPolicyRepository(other.policyRepository, defaultZoneDeltas, policyVersion) : this.shareWith(other.policyRepository);
        if (servicePolicies.getTagPolicies() != null && CollectionUtils.isNotEmpty(defaultZoneDeltasForTagPolicies)) {
            if (other.tagPolicyRepository == null) {
                ArrayList<RangerPolicy> tagPolicies = new ArrayList<RangerPolicy>();
                for (RangerPolicyDelta delta : defaultZoneDeltasForTagPolicies) {
                    if (delta.getChangeType() == 0) {
                        tagPolicies.add(delta.getPolicy());
                        continue;
                    }
                    LOG.warn((Object)("Expected changeType:[0], found policy-change-delta:[" + delta + "]"));
                }
                servicePolicies.getTagPolicies().setPolicies(tagPolicies);
                this.tagPolicyRepository = new RangerPolicyRepository(servicePolicies.getTagPolicies(), this.pluginContext, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
            } else {
                this.tagPolicyRepository = new RangerPolicyRepository(other.tagPolicyRepository, defaultZoneDeltasForTagPolicies, policyVersion);
            }
        } else {
            this.tagPolicyRepository = this.shareWith(other.tagPolicyRepository);
        }
        List<RangerContextEnricher> list = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(list)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = list;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(list);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        this.reorderPolicyEvaluators();
    }

    private void buildZoneTrie(ServicePolicies servicePolicies) {
        Map<String, ServicePolicies.SecurityZoneInfo> securityZones;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyEngine.buildZoneTrie()");
        }
        if (MapUtils.isNotEmpty(securityZones = servicePolicies.getSecurityZones())) {
            RangerServiceDef serviceDef = servicePolicies.getServiceDef();
            ArrayList<RangerZoneResourceMatcher> matchers = new ArrayList<RangerZoneResourceMatcher>();
            for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> securityZone : securityZones.entrySet()) {
                String zoneName = securityZone.getKey();
                ServicePolicies.SecurityZoneInfo zoneDetails = securityZone.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Building matchers for zone:[" + zoneName + "]"));
                }
                for (Map map : zoneDetails.getResources()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Building matcher for resource:[" + map + "] in zone:[" + zoneName + "]"));
                    }
                    HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                    for (Map.Entry entry : map.entrySet()) {
                        String resourceDefName = (String)entry.getKey();
                        List resourceValues = (List)entry.getValue();
                        RangerPolicy.RangerPolicyResource policyResource = new RangerPolicy.RangerPolicyResource();
                        policyResource.setIsExcludes(false);
                        policyResource.setIsRecursive(EmbeddedServiceDefsUtil.isRecursiveEnabled(serviceDef, resourceDefName));
                        policyResource.setValues(resourceValues);
                        policyResources.put(resourceDefName, policyResource);
                    }
                    matchers.add(new RangerZoneResourceMatcher(zoneName, policyResources, serviceDef));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Built matcher for resource:[" + map + "] in zone:[" + zoneName + "]"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Built all matchers for zone:[" + zoneName + "]"));
                }
                if (!zoneDetails.getContainsAssociatedTagService().booleanValue()) continue;
                this.zoneTagServiceMap.put(zoneName, zoneName);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Built matchers for all Zones");
            }
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                this.resourceZoneTrie.put(resourceDef.getName(), new RangerResourceTrie(resourceDef, matchers));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyEngine.buildZoneTrie()");
        }
    }

    private RangerPolicyRepository shareWith(RangerPolicyRepository other) {
        if (other != null) {
            other.setShared();
        }
        return other;
    }

    private void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> reorderEvaluators()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REBALANCE_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REBALANCE_LOG, "RangerPolicyEngine.reorderEvaluators()");
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.reorderPolicyEvaluators();
        }
        if (this.policyRepository != null) {
            this.policyRepository.reorderPolicyEvaluators();
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== reorderEvaluators()");
        }
    }

    private void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyEngine.cleanup()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cleanUp(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
        }
        this.preCleanup(false);
        if (this.policyRepository != null) {
            this.policyRepository.cleanup();
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.cleanup();
        }
        if (MapUtils.isNotEmpty(this.zonePolicyRepositories)) {
            for (Map.Entry<String, RangerPolicyRepository> entry : this.zonePolicyRepositories.entrySet()) {
                entry.getValue().cleanup();
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyEngine.cleanup()");
        }
    }
}

