/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestProcessor;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public class RangerDefaultRequestProcessor
implements RangerAccessRequestProcessor {
    protected final PolicyEngine policyEngine;

    public RangerDefaultRequestProcessor(PolicyEngine policyEngine) {
        this.policyEngine = policyEngine;
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        Set<String> roles;
        String owner;
        this.setResourceServiceDef(request);
        if (request instanceof RangerAccessRequestImpl) {
            RangerAccessRequestImpl reqImpl = (RangerAccessRequestImpl)request;
            if (reqImpl.getClientIPAddress() == null) {
                reqImpl.extractAndSetClientIPAddress(this.policyEngine.getUseForwardedIPAddress(), this.policyEngine.getTrustedProxyAddresses());
            }
            if (this.policyEngine.getPluginContext() != null) {
                if (reqImpl.getClusterName() == null) {
                    reqImpl.setClusterName(this.policyEngine.getPluginContext().getClusterName());
                }
                if (reqImpl.getClusterType() == null) {
                    reqImpl.setClusterType(this.policyEngine.getPluginContext().getClusterType());
                }
            }
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        String string = owner = request.getResource() != null ? request.getResource().getOwnerUser() : null;
        if (StringUtils.isNotEmpty((String)owner)) {
            RangerAccessRequestUtil.setOwnerInContext(request.getContext(), owner);
        }
        if (CollectionUtils.isEmpty(roles = request.getUserRoles())) {
            roles = this.policyEngine.getPluginContext().getAuthContext().getRolesForUserAndGroups(request.getUser(), request.getUserGroups());
        }
        if (CollectionUtils.isNotEmpty(roles)) {
            RangerAccessRequestUtil.setCurrentUserRolesInContext(request.getContext(), roles);
        }
        this.enrich(request);
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        List<RangerContextEnricher> enrichers = this.policyEngine.getAllContextEnrichers();
        if (!CollectionUtils.isEmpty(enrichers)) {
            for (RangerContextEnricher enricher : enrichers) {
                enricher.enrich(request);
            }
        }
    }

    private void setResourceServiceDef(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null && resource instanceof RangerMutableResource) {
            RangerMutableResource mutable = (RangerMutableResource)resource;
            mutable.setServiceDef(this.policyEngine.getServiceDef());
        }
    }
}

