/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ranger.authorization.utils.JsonUtils;

public class RangerPluginCapability {
    private final long pluginCapabilities;
    private static final String baseRangerCapabilities = RangerPluginCapability.computeBaseCapabilities();

    public RangerPluginCapability() {
        long vector = 0L;
        for (RangerPluginFeature feature : RangerPluginFeature.values()) {
            vector += 1L << feature.ordinal();
        }
        this.pluginCapabilities = vector;
    }

    public RangerPluginCapability(long pluginCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
    }

    public RangerPluginCapability(List<String> capabilities) {
        long vector = 0L;
        for (String capability : capabilities) {
            try {
                RangerPluginFeature feature = RangerPluginFeature.valueOf(capability);
                vector += 1L << feature.ordinal();
            }
            catch (Exception exception) {}
        }
        this.pluginCapabilities = vector;
    }

    public long getPluginCapabilities() {
        return this.pluginCapabilities;
    }

    public List<String> compare(RangerPluginCapability other) {
        List<String> ret;
        if (this.pluginCapabilities != other.pluginCapabilities) {
            long mismatchedCapabilitiesVector = this.pluginCapabilities ^ other.pluginCapabilities;
            List<String> missingFeatures = RangerPluginCapability.toStrings(mismatchedCapabilitiesVector);
            if (mismatchedCapabilitiesVector > 1L << RangerPluginFeature.values().length) {
                missingFeatures.add("unknown");
            }
            ret = missingFeatures;
        } else {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    public String toString() {
        List<String> capabilities = RangerPluginCapability.toStrings(this.pluginCapabilities);
        return JsonUtils.objectToJson(capabilities);
    }

    public static String getBaseRangerCapabilities() {
        return baseRangerCapabilities;
    }

    private static List<String> toStrings(long vector) {
        ArrayList<String> ret = new ArrayList<String>();
        for (RangerPluginFeature feature : RangerPluginFeature.values()) {
            long test = 1L << feature.ordinal();
            if ((test & vector) <= 0L) continue;
            ret.add(feature.name());
        }
        return ret;
    }

    private static String computeBaseCapabilities() {
        List<String> baseCapabilities = Arrays.asList(RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_TAG_POLICIES.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_MASKING_AND_ROW_FILTERING.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_MACROS.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_AUDIT_MODE.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_RESOURCE_IS_VALID_LEAF.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_VALIDITY_PERIOD.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_POLICY_PRIORITY.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_SECURITY_ZONE.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_POLICY_LEVEL_CONDITION.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_DENY_ALL_ELSE_POLICY.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_ROLE.getName(), RangerPluginFeature.RANGER_PLUGIN_CAPABILITY_ROLE_DOWNLOAD_TIMER.getName());
        return Long.toHexString(new RangerPluginCapability(baseCapabilities).getPluginCapabilities());
    }

    public static enum RangerPluginFeature {
        RANGER_PLUGIN_CAPABILITY_TAG_POLICIES("Tag Policies"),
        RANGER_PLUGIN_CAPABILITY_MASKING_AND_ROW_FILTERING("Masking and Row-filtering"),
        RANGER_PLUGIN_CAPABILITY_MACROS("Macros"),
        RANGER_PLUGIN_CAPABILITY_AUDIT_MODE("Audit Mode"),
        RANGER_PLUGIN_CAPABILITY_RESOURCE_IS_VALID_LEAF("Support for leaf node"),
        RANGER_PLUGIN_CAPABILITY_VALIDITY_PERIOD("Validity Period"),
        RANGER_PLUGIN_CAPABILITY_POLICY_PRIORITY("Policy Priority"),
        RANGER_PLUGIN_CAPABILITY_SECURITY_ZONE("Security Zone"),
        RANGER_PLUGIN_CAPABILITY_POLICY_LEVEL_CONDITION("Policy-level Condition"),
        RANGER_PLUGIN_CAPABILITY_DENY_ALL_ELSE_POLICY("Deny-all-else Policy"),
        RANGER_PLUGIN_CAPABILITY_ROLE("Role"),
        RANGER_PLUGIN_CAPABILITY_ROLE_DOWNLOAD_TIMER("Role Timer");

        private String name;

        private RangerPluginFeature(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

