/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.util.RangerRoles;

public class RangerRolesUtil {
    private final long roleVersion;
    private final Map<String, Set<String>> userRoleMapping = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> groupRoleMapping = new HashMap<String, Set<String>>();

    public RangerRolesUtil(RangerRoles roles) {
        if (roles != null) {
            this.roleVersion = roles.getRoleVersion();
            if (CollectionUtils.isNotEmpty(roles.getRangerRoles())) {
                for (RangerRole role : roles.getRangerRoles()) {
                    Set<RangerRole> containedRoles = this.getAllContainedRoles(roles.getRangerRoles(), role);
                    this.buildMap(this.userRoleMapping, role, containedRoles, true);
                    this.buildMap(this.groupRoleMapping, role, containedRoles, false);
                }
            }
        } else {
            this.roleVersion = -1L;
        }
    }

    public long getRoleVersion() {
        return this.roleVersion;
    }

    public Map<String, Set<String>> getUserRoleMapping() {
        return this.userRoleMapping;
    }

    public Map<String, Set<String>> getGroupRoleMapping() {
        return this.groupRoleMapping;
    }

    private Set<RangerRole> getAllContainedRoles(Set<RangerRole> roles, RangerRole role) {
        HashSet<RangerRole> allRoles = new HashSet<RangerRole>();
        allRoles.add(role);
        this.addContainedRoles(allRoles, roles, role);
        return allRoles;
    }

    private void addContainedRoles(Set<RangerRole> allRoles, Set<RangerRole> roles, RangerRole role) {
        List<RangerRole.RoleMember> roleMembers = role.getRoles();
        for (RangerRole.RoleMember roleMember : roleMembers) {
            RangerRole containedRole = this.getContainedRole(roles, roleMember.getName());
            if (containedRole == null || allRoles.contains(containedRole)) continue;
            allRoles.add(containedRole);
            this.addContainedRoles(allRoles, roles, containedRole);
        }
    }

    private void buildMap(Map<String, Set<String>> map, RangerRole role, Set<RangerRole> containedRoles, boolean isUser) {
        this.buildMap(map, role, role.getName(), isUser);
        for (RangerRole containedRole : containedRoles) {
            this.buildMap(map, containedRole, role.getName(), isUser);
        }
    }

    private void buildMap(Map<String, Set<String>> map, RangerRole role, String roleName, boolean isUser) {
        for (RangerRole.RoleMember userOrGroup : isUser ? role.getUsers() : role.getGroups()) {
            if (!StringUtils.isNotEmpty((String)userOrGroup.getName())) continue;
            Set<String> roleNames = map.get(userOrGroup.getName());
            if (roleNames == null) {
                roleNames = new HashSet<String>();
                map.put(userOrGroup.getName(), roleNames);
            }
            roleNames.add(roleName);
        }
    }

    private RangerRole getContainedRole(Set<RangerRole> roles, String role) {
        return roles.stream().filter(containedRole -> role.equals(containedRole.getName())).findAny().orElse(null);
    }
}

