/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Function;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.ComparisonChain;

public class RemoteEditLog
implements Comparable<RemoteEditLog> {
    private long startTxId = -12345L;
    private long endTxId = -12345L;
    private boolean isInProgress = false;
    public static final Function<RemoteEditLog, Long> GET_START_TXID = new Function<RemoteEditLog, Long>(){

        @Override
        public Long apply(RemoteEditLog log) {
            if (null == log) {
                return -12345L;
            }
            return log.getStartTxId();
        }
    };

    public RemoteEditLog() {
    }

    public RemoteEditLog(long startTxId, long endTxId) {
        this.startTxId = startTxId;
        this.endTxId = endTxId;
        this.isInProgress = endTxId == -12345L;
    }

    public RemoteEditLog(long startTxId, long endTxId, boolean inProgress) {
        this.startTxId = startTxId;
        this.endTxId = endTxId;
        this.isInProgress = inProgress;
    }

    public long getStartTxId() {
        return this.startTxId;
    }

    public long getEndTxId() {
        return this.endTxId;
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    public String toString() {
        if (!this.isInProgress) {
            return "[" + this.startTxId + "," + this.endTxId + "]";
        }
        return "[" + this.startTxId + "-? (in-progress)]";
    }

    @Override
    public int compareTo(RemoteEditLog log) {
        return ComparisonChain.start().compare(this.startTxId, log.startTxId).compare(this.endTxId, log.endTxId).result();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemoteEditLog)) {
            return false;
        }
        return this.compareTo((RemoteEditLog)o) == 0;
    }

    public int hashCode() {
        return (int)(this.startTxId * this.endTxId);
    }
}

