/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeltaTableName {
    private static final String TABLE_GROUP_NAME = "table";
    private static final String SNAPSHOT_ID_GROUP_NAME = "snapshotId";
    private static final String TIMESTAMP_GROUP_NAME = "timestamp";
    private static final Pattern TABLE_PATTERN = Pattern.compile(String.format("(?<%s>[^@]+)(?:@v(?<%s>[0-9]+))?(?:@t(?<%s>[0-9.\\-: ]+))?", "table", "snapshotId", "timestamp"));
    private static final DateTimeFormatter TIMESTAMP_PARSER = new DateTimeFormatterBuilder().appendPattern("yyyy[-MM[-dd[ HH[:mm[:ss]]]]]").parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter().withZone(ZoneId.of("UTC"));
    private final String tableNameOrPath;
    private final Optional<Long> snapshotId;
    private final Optional<Long> timestampMillisUtc;

    public DeltaTableName(String tableNameOrPath, Optional<Long> snapshotId, Optional<Long> timestampMillisUtc) {
        this.tableNameOrPath = Objects.requireNonNull(tableNameOrPath, "tableNameOrPath is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.timestampMillisUtc = Objects.requireNonNull(timestampMillisUtc, "timestampMillisUtc is null");
    }

    public String getTableNameOrPath() {
        return this.tableNameOrPath;
    }

    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    public Optional<Long> getTimestampMillisUtc() {
        return this.timestampMillisUtc;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("Table[" + this.tableNameOrPath + "]");
        this.snapshotId.map(id -> builder.append("@v" + id));
        this.timestampMillisUtc.map(ts -> builder.append("@t" + new Timestamp((long)ts)));
        return builder.toString();
    }

    public static DeltaTableName from(String tableName) {
        Matcher match = TABLE_PATTERN.matcher(tableName);
        if (!match.matches()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta table name: " + tableName + ", Expected table name form 'tableName[@v<snapshotId>][@t<snapshotAsOfTimestamp>]'. The table can have either a particular snapshot identifier or a timestamp of the snapshot. If timestamp is given the latest snapshot of the table that was generated at or before the given timestamp is read");
        }
        String tableNameOrPath = match.group(TABLE_GROUP_NAME);
        String snapshotValue = match.group(SNAPSHOT_ID_GROUP_NAME);
        Optional<Object> snapshot = Optional.empty();
        if (snapshotValue != null) {
            snapshot = Optional.of(Long.parseLong(snapshotValue));
        }
        Optional<Long> timestampMillisUtc = Optional.empty();
        String timestampValue = match.group(TIMESTAMP_GROUP_NAME);
        if (timestampValue != null) {
            try {
                timestampMillisUtc = Optional.of(LocalDateTime.from(TIMESTAMP_PARSER.parse(timestampValue)).toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            catch (IllegalArgumentException | DateTimeParseException exception) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Delta table name: %s, given snapshot timestamp (%s) format is not valid. Expected timestamp format 'YYYY-MM-DD HH:mm:ss'", tableName, timestampValue), (Throwable)exception);
            }
        }
        if (snapshot.isPresent() && timestampMillisUtc.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Delta table name: " + tableName + ", Table suffix contains both snapshot id and timestamp of snapshot to read. Only one of them is supported.");
        }
        return new DeltaTableName(tableNameOrPath, snapshot, timestampMillisUtc);
    }
}

