/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.delta.DeltaErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class DeltaTypeUtils {
    private DeltaTypeUtils() {
    }

    public static TypeSignature convertDeltaDataTypePrestoDataType(SchemaTableName tableName, String columnName, DataType deltaType) {
        Preconditions.checkArgument((deltaType != null ? 1 : 0) != 0);
        if (deltaType instanceof StructType) {
            StructType deltaStructType = (StructType)deltaType;
            ImmutableList.Builder typeSignatureBuilder = ImmutableList.builder();
            Arrays.stream(deltaStructType.getFields()).forEach(field -> {
                String rowFieldName = field.getName().toLowerCase(Locale.US);
                TypeSignature rowFieldType = DeltaTypeUtils.convertDeltaDataTypePrestoDataType(tableName, columnName + "." + field.getName(), field.getDataType());
                typeSignatureBuilder.add((Object)TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(rowFieldName, false)), rowFieldType)));
            });
            return new TypeSignature("row", (List)typeSignatureBuilder.build());
        }
        if (deltaType instanceof ArrayType) {
            ArrayType deltaArrayType = (ArrayType)deltaType;
            TypeSignature elementType = DeltaTypeUtils.convertDeltaDataTypePrestoDataType(tableName, columnName, deltaArrayType.getElementType());
            return new TypeSignature("array", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)elementType)));
        }
        if (deltaType instanceof MapType) {
            MapType deltaMapType = (MapType)deltaType;
            TypeSignature keyType = DeltaTypeUtils.convertDeltaDataTypePrestoDataType(tableName, columnName, deltaMapType.getKeyType());
            TypeSignature valueType = DeltaTypeUtils.convertDeltaDataTypePrestoDataType(tableName, columnName, deltaMapType.getValueType());
            return new TypeSignature("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)keyType), (Object)TypeSignatureParameter.of((TypeSignature)valueType)));
        }
        return DeltaTypeUtils.convertDeltaPrimitiveTypeToPrestoPrimitiveType(tableName, columnName, deltaType).getTypeSignature();
    }

    public static Object convertPartitionValue(String columnName, String valueString, Type type) {
        if (valueString == null) {
            return null;
        }
        try {
            if (type.equals(com.facebook.presto.common.type.BooleanType.BOOLEAN)) {
                Preconditions.checkArgument((valueString.equalsIgnoreCase("true") || valueString.equalsIgnoreCase("false") ? 1 : 0) != 0);
                return Boolean.valueOf(valueString);
            }
            if (type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(com.facebook.presto.common.type.IntegerType.INTEGER) || type.equals(BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.equals(RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals(com.facebook.presto.common.type.DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type instanceof VarcharType) {
                Slice value = Slices.utf8Slice((String)valueString);
                VarcharType varcharType = (VarcharType)type;
                if (!varcharType.isUnbounded() && SliceUtf8.countCodePoints((Slice)value) > varcharType.getLengthSafe()) {
                    throw new IllegalArgumentException();
                }
                return value;
            }
            if (type.equals(VarbinaryType.VARBINARY)) {
                return Slices.utf8Slice((String)valueString);
            }
            if (Decimals.isShortDecimal((Type)type) || Decimals.isLongDecimal((Type)type)) {
                com.facebook.presto.common.type.DecimalType decimalType = (com.facebook.presto.common.type.DecimalType)type;
                BigDecimal decimal = new BigDecimal(valueString);
                if ((decimal = decimal.setScale(decimalType.getScale(), 7)).precision() > decimalType.getPrecision()) {
                    throw new IllegalArgumentException();
                }
                BigInteger unscaledValue = decimal.unscaledValue();
                return Decimals.isShortDecimal((Type)type) ? Long.valueOf(unscaledValue.longValue()) : Decimals.encodeUnscaledValue((BigInteger)unscaledValue);
            }
            if (type.equals(DateType.DATE)) {
                return LocalDate.parse(valueString, DateTimeFormatter.ISO_LOCAL_DATE).toEpochDay();
            }
            if (type.equals(com.facebook.presto.common.type.TimestampType.TIMESTAMP)) {
                return Timestamp.valueOf(valueString).toLocalDateTime().toEpochSecond(ZoneOffset.UTC) * 1000L;
            }
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_UNSUPPORTED_COLUMN_TYPE, String.format("Unsupported data type '%s' for partition column %s", type, columnName));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_INVALID_PARTITION_VALUE, String.format("Can not parse partition value '%s' of type '%s' for partition column '%s'", valueString, type, columnName), (Throwable)e);
        }
    }

    private static Type convertDeltaPrimitiveTypeToPrestoPrimitiveType(SchemaTableName tableName, String columnName, DataType deltaType) {
        if (deltaType instanceof BinaryType) {
            return VarbinaryType.VARBINARY;
        }
        if (deltaType instanceof BooleanType) {
            return com.facebook.presto.common.type.BooleanType.BOOLEAN;
        }
        if (deltaType instanceof ByteType) {
            return TinyintType.TINYINT;
        }
        if (deltaType instanceof io.delta.standalone.types.DateType) {
            return DateType.DATE;
        }
        if (deltaType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)deltaType;
            return com.facebook.presto.common.type.DecimalType.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (deltaType instanceof DoubleType) {
            return com.facebook.presto.common.type.DoubleType.DOUBLE;
        }
        if (deltaType instanceof FloatType) {
            return RealType.REAL;
        }
        if (deltaType instanceof IntegerType) {
            return com.facebook.presto.common.type.IntegerType.INTEGER;
        }
        if (deltaType instanceof LongType) {
            return BigintType.BIGINT;
        }
        if (deltaType instanceof ShortType) {
            return SmallintType.SMALLINT;
        }
        if (deltaType instanceof StringType) {
            return VarcharType.createUnboundedVarcharType();
        }
        if (deltaType instanceof TimestampType) {
            return com.facebook.presto.common.type.TimestampType.TIMESTAMP;
        }
        throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_UNSUPPORTED_COLUMN_TYPE, String.format("Column '%s' in Delta table %s contains unsupported data type: %s", columnName, tableName, deltaType.getCatalogString()));
    }
}

