/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.delta.DeltaColumnHandle;
import com.facebook.presto.delta.DeltaSessionProperties;
import com.facebook.presto.delta.DeltaTableHandle;
import com.facebook.presto.parquet.rule.ParquetDereferencePushDown;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class DeltaParquetDereferencePushDown
extends ParquetDereferencePushDown {
    public DeltaParquetDereferencePushDown(RowExpressionService rowExpressionService) {
        super(rowExpressionService);
    }

    protected boolean isParquetDereferenceEnabled(ConnectorSession session, TableHandle tableHandle) {
        return tableHandle != null && tableHandle.getConnectorHandle() instanceof DeltaTableHandle && DeltaSessionProperties.isParquetDereferencePushdownEnabled(session);
    }

    protected String getColumnName(ColumnHandle columnHandle) {
        Preconditions.checkArgument((boolean)(columnHandle instanceof DeltaColumnHandle), (Object)("Expected Delta column handle, instead got: " + columnHandle.getClass()));
        return ((DeltaColumnHandle)columnHandle).getName();
    }

    protected ColumnHandle createSubfieldColumnHandle(ColumnHandle baseColumnHandle, Subfield subfield, Type subfieldDataType, String subfieldColumnName) {
        Preconditions.checkArgument((boolean)(baseColumnHandle instanceof DeltaColumnHandle), (Object)("Expected Delta column handle, instead got: " + baseColumnHandle.getClass()));
        return new DeltaColumnHandle(subfieldColumnName, subfieldDataType.getTypeSignature(), DeltaColumnHandle.ColumnType.SUBFIELD, Optional.of(subfield));
    }
}

