/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.metadata.Stream;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class StreamId {
    private final int column;
    private final int sequence;
    private final Stream.StreamKind streamKind;

    public StreamId(Stream stream) {
        this.column = stream.getColumn();
        this.sequence = stream.getSequence();
        this.streamKind = stream.getStreamKind();
    }

    public StreamId(int column, int sequence, Stream.StreamKind streamKind) {
        this.column = column;
        this.sequence = sequence;
        this.streamKind = streamKind;
    }

    public int getColumn() {
        return this.column;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Stream.StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.sequence, this.streamKind});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StreamId other = (StreamId)obj;
        return this.column == other.column && this.sequence == other.sequence && this.streamKind == other.streamKind;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("sequence", this.sequence).add("streamKind", (Object)this.streamKind).toString();
    }
}

