/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class Stream {
    private final int column;
    private final StreamKind streamKind;
    private final int length;
    private final boolean useVInts;
    private final int sequence;
    private final Optional<Long> offset;

    public Stream(int column, int sequence, StreamKind streamKind, int length, boolean useVInts) {
        this(column, streamKind, length, useVInts, sequence, Optional.empty());
    }

    public Stream(int column, StreamKind streamKind, int length, boolean useVInts, int sequence, Optional<Long> offset) {
        this.column = column;
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.length = length;
        this.useVInts = useVInts;
        this.sequence = sequence;
        this.offset = Objects.requireNonNull(offset, "offset is null");
    }

    public int getColumn() {
        return this.column;
    }

    public StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUseVInts() {
        return this.useVInts;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Optional<Long> getOffset() {
        return this.offset;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("streamKind", (Object)this.streamKind).add("length", this.length).add("useVInts", this.useVInts).add("sequence", this.sequence).add("offset", this.offset).toString();
    }

    public Stream withOffset(long offset) {
        return new Stream(this.column, this.streamKind, this.length, this.useVInts, this.sequence, Optional.of(offset));
    }

    public static enum StreamKind {
        PRESENT(StreamArea.DATA),
        DATA(StreamArea.DATA),
        LENGTH(StreamArea.DATA),
        DICTIONARY_DATA(StreamArea.DATA),
        DICTIONARY_COUNT(StreamArea.INDEX),
        SECONDARY(StreamArea.DATA),
        ROW_INDEX(StreamArea.INDEX),
        BLOOM_FILTER(StreamArea.INDEX),
        BLOOM_FILTER_UTF8(StreamArea.INDEX),
        IN_DICTIONARY(StreamArea.DATA),
        ROW_GROUP_DICTIONARY(StreamArea.DATA),
        ROW_GROUP_DICTIONARY_LENGTH(StreamArea.DATA),
        IN_MAP(StreamArea.DATA);

        private final StreamArea streamArea;

        private StreamKind(StreamArea streamArea) {
            this.streamArea = Objects.requireNonNull(streamArea, "streamArea is null");
        }

        public StreamArea getStreamArea() {
            return this.streamArea;
        }
    }

    public static enum StreamArea {
        INDEX,
        DATA;

    }
}

