/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DoubleStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private boolean hasNan;
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;

    @Override
    public void addBlock(Type type, Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            double value = type == RealType.REAL ? (double)Float.intBitsToFloat((int)type.getLong(block, position)) : type.getDouble(block, position);
            this.addValue(value);
        }
    }

    public void addValue(double value) {
        ++this.nonNullValueCount;
        if (Double.isNaN(value)) {
            this.hasNan = true;
        } else {
            this.minimum = Math.min(value, this.minimum);
            this.maximum = Math.max(value, this.maximum);
        }
    }

    private void addDoubleStatistics(long valueCount, DoubleStatistics value) {
        Objects.requireNonNull(value, "value is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMinPrimitive(), this.minimum);
        this.maximum = Math.max(value.getMaxPrimitive(), this.maximum);
    }

    private Optional<DoubleStatistics> buildDoubleStatistics() {
        if (this.nonNullValueCount == 0L || this.hasNan) {
            return Optional.empty();
        }
        return Optional.of(new DoubleStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DoubleStatistics> doubleStatistics = this.buildDoubleStatistics();
        if (doubleStatistics.isPresent()) {
            return new DoubleColumnStatistics(this.nonNullValueCount, null, doubleStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null);
    }

    public static Optional<DoubleStatistics> mergeDoubleStatistics(List<ColumnStatistics> stats) {
        DoubleStatisticsBuilder doubleStatisticsBuilder = new DoubleStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            DoubleStatistics partialStatistics = columnStatistics.getDoubleStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            doubleStatisticsBuilder.addDoubleStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return doubleStatisticsBuilder.buildDoubleStatistics();
    }
}

