/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.LongValueStatisticsBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;

public class ShortDecimalStatisticsBuilder
implements LongValueStatisticsBuilder {
    public static final long SHORT_DECIMAL_VALUE_BYTES = 8L;
    private final int scale;
    private long nonNullValueCount;
    private long minimum = Long.MAX_VALUE;
    private long maximum = Long.MIN_VALUE;

    public ShortDecimalStatisticsBuilder(int scale) {
        this.scale = scale;
    }

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        this.minimum = Math.min(value, this.minimum);
        this.maximum = Math.max(value, this.maximum);
    }

    private Optional<DecimalStatistics> buildDecimalStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new DecimalStatistics(new BigDecimal(BigInteger.valueOf(this.minimum), this.scale), new BigDecimal(BigInteger.valueOf(this.maximum), this.scale), 8L));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DecimalStatistics> decimalStatistics = this.buildDecimalStatistics();
        if (decimalStatistics.isPresent()) {
            return new DecimalColumnStatistics(this.nonNullValueCount, null, decimalStatistics.get());
        }
        return new ColumnStatistics(this.nonNullValueCount, null);
    }
}

