/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.ValueOutputStream;
import java.util.Optional;

public interface LongOutputStream
extends ValueOutputStream<LongStreamCheckpoint> {
    public static LongOutputStream createLengthOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding) {
        return LongOutputStream.createLongOutputStream(columnWriterOptions, dwrfEncryptor, orcEncoding, Stream.StreamKind.LENGTH);
    }

    public static LongOutputStream createDataOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding) {
        return LongOutputStream.createLongOutputStream(columnWriterOptions, dwrfEncryptor, orcEncoding, Stream.StreamKind.DATA);
    }

    public static LongOutputStream createLongOutputStream(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, Stream.StreamKind streamKind) {
        if (orcEncoding == OrcEncoding.DWRF) {
            return new LongOutputStreamV1(columnWriterOptions, dwrfEncryptor, false, streamKind);
        }
        return new LongOutputStreamV2(columnWriterOptions, false, streamKind);
    }

    public void writeLong(long var1);
}

