/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.ByteInputStream;
import com.facebook.presto.orc.stream.DecimalInputStream;
import com.facebook.presto.orc.stream.DoubleInputStream;
import com.facebook.presto.orc.stream.FloatInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import java.util.Objects;
import javax.annotation.Nullable;

public class MissingInputStreamSource<S extends ValueInputStream<?>>
implements InputStreamSource<S> {
    private static final MissingInputStreamSource<BooleanInputStream> BOOLEAN_MISSING_STREAM_SOURCE = new MissingInputStreamSource<BooleanInputStream>(BooleanInputStream.class);
    private static final MissingInputStreamSource<ByteInputStream> BYTE_MISSING_STREAM_SOURCE = new MissingInputStreamSource<ByteInputStream>(ByteInputStream.class);
    private static final MissingInputStreamSource<ByteArrayInputStream> BYTE_ARRAY_MISSING_STREAM_SOURCE = new MissingInputStreamSource<ByteArrayInputStream>(ByteArrayInputStream.class);
    private static final MissingInputStreamSource<DecimalInputStream> DECIMAL_MISSING_STREAM_SOURCE = new MissingInputStreamSource<DecimalInputStream>(DecimalInputStream.class);
    private static final MissingInputStreamSource<DoubleInputStream> DOUBLE_MISSING_STREAM_SOURCE = new MissingInputStreamSource<DoubleInputStream>(DoubleInputStream.class);
    private static final MissingInputStreamSource<FloatInputStream> FLOAT_MISSING_STREAM_SOURCE = new MissingInputStreamSource<FloatInputStream>(FloatInputStream.class);
    private static final MissingInputStreamSource<LongInputStream> LONG_MISSING_STREAM_SOURCE = new MissingInputStreamSource<LongInputStream>(LongInputStream.class);
    private static final MissingInputStreamSource<RowGroupDictionaryLengthInputStream> ROW_GROUP_DICTIONARY_LENGTH_MISSING_STREAM_SOURCE = new MissingInputStreamSource<RowGroupDictionaryLengthInputStream>(RowGroupDictionaryLengthInputStream.class);
    private final Class<S> streamType;

    private MissingInputStreamSource(Class<S> streamType) {
        this.streamType = Objects.requireNonNull(streamType, "streamType is null");
    }

    public static InputStreamSource<BooleanInputStream> getBooleanMissingStreamSource() {
        return BOOLEAN_MISSING_STREAM_SOURCE;
    }

    public static InputStreamSource<ByteInputStream> getByteMissingStreamSource() {
        return BYTE_MISSING_STREAM_SOURCE;
    }

    public static MissingInputStreamSource<ByteArrayInputStream> getByteArrayMissingStreamSource() {
        return BYTE_ARRAY_MISSING_STREAM_SOURCE;
    }

    public static MissingInputStreamSource<DecimalInputStream> getDecimalMissingStreamSource() {
        return DECIMAL_MISSING_STREAM_SOURCE;
    }

    public static MissingInputStreamSource<DoubleInputStream> getDoubleMissingStreamSource() {
        return DOUBLE_MISSING_STREAM_SOURCE;
    }

    public static MissingInputStreamSource<FloatInputStream> getFloatMissingStreamSource() {
        return FLOAT_MISSING_STREAM_SOURCE;
    }

    public static InputStreamSource<LongInputStream> getLongMissingStreamSource() {
        return LONG_MISSING_STREAM_SOURCE;
    }

    public static MissingInputStreamSource<RowGroupDictionaryLengthInputStream> getRowGroupDictionaryLengthMissingStreamSource() {
        return ROW_GROUP_DICTIONARY_LENGTH_MISSING_STREAM_SOURCE;
    }

    public static <S extends ValueInputStream<?>> InputStreamSource<S> missingStreamSource(Class<S> streamType) {
        if (MissingInputStreamSource.BOOLEAN_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return BOOLEAN_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.LONG_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return LONG_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.BYTE_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return BYTE_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.BYTE_ARRAY_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return BYTE_ARRAY_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.DECIMAL_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return DECIMAL_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.DOUBLE_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return DOUBLE_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.FLOAT_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return FLOAT_MISSING_STREAM_SOURCE;
        }
        if (MissingInputStreamSource.ROW_GROUP_DICTIONARY_LENGTH_MISSING_STREAM_SOURCE.streamType.equals(streamType)) {
            return ROW_GROUP_DICTIONARY_LENGTH_MISSING_STREAM_SOURCE;
        }
        return new MissingInputStreamSource<S>(streamType);
    }

    @Override
    public Class<S> getStreamType() {
        return this.streamType;
    }

    @Override
    @Nullable
    public S openStream() {
        return null;
    }
}

