/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.delta.DeltaColumn;
import com.facebook.presto.delta.DeltaErrorCode;
import com.facebook.presto.delta.DeltaTable;
import com.facebook.presto.delta.DeltaTypeUtils;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import io.delta.standalone.DeltaLog;
import io.delta.standalone.Snapshot;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.actions.Metadata;
import io.delta.standalone.data.CloseableIterator;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class DeltaClient {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public DeltaClient(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    public Optional<DeltaTable> getTable(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation, Optional<Long> snapshotId, Optional<Long> snapshotAsOfTimestampMillis) {
        Optional<DeltaLog> deltaLog = this.loadDeltaTableLog(session, new Path(tableLocation), schemaTableName);
        if (!deltaLog.isPresent()) {
            return Optional.empty();
        }
        Snapshot snapshot = snapshotId.isPresent() ? DeltaClient.getSnapshotById(deltaLog.get(), snapshotId.get(), schemaTableName) : (snapshotAsOfTimestampMillis.isPresent() ? DeltaClient.getSnapshotAsOfTimestamp(deltaLog.get(), snapshotAsOfTimestampMillis.get(), schemaTableName) : deltaLog.get().snapshot());
        Metadata metadata = snapshot.getMetadata();
        String format = metadata.getFormat().getProvider();
        if (!DeltaTable.DataFormat.PARQUET.name().equalsIgnoreCase(format)) {
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_UNSUPPORTED_DATA_FORMAT, String.format("Delta table %s has unsupported data format: %s. Currently only Parquet data format is supported", schemaTableName, format));
        }
        return Optional.of(new DeltaTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), tableLocation, Optional.of(snapshot.getVersion()), DeltaClient.getSchema(schemaTableName, metadata)));
    }

    public CloseableIterator<AddFile> listFiles(ConnectorSession session, DeltaTable deltaTable) {
        Preconditions.checkArgument((boolean)deltaTable.getSnapshotId().isPresent(), (Object)"Snapshot id is missing from the Delta table");
        Optional<DeltaLog> deltaLog = this.loadDeltaTableLog(session, new Path(deltaTable.getTableLocation()), new SchemaTableName(deltaTable.getSchemaName(), deltaTable.getTableName()));
        if (!deltaLog.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Delta table (%s.%s) no longer exists.", deltaTable.getSchemaName(), deltaTable.getTableName()));
        }
        return deltaLog.get().getSnapshotForVersionAsOf(deltaTable.getSnapshotId().get().longValue()).scan().getFiles();
    }

    private Optional<DeltaLog> loadDeltaTableLog(ConnectorSession session, Path tableLocation, SchemaTableName schemaTableName) {
        try {
            HdfsContext hdfsContext = new HdfsContext(session, schemaTableName.getSchemaName(), schemaTableName.getTableName(), tableLocation.toString(), false);
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, tableLocation);
            if (!fileSystem.isDirectory(tableLocation)) {
                return Optional.empty();
            }
            return Optional.of(DeltaLog.forTable((Configuration)this.hdfsEnvironment.getConfiguration(hdfsContext, tableLocation), (Path)tableLocation));
        }
        catch (IOException ioException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to load Delta table: " + ioException.getMessage(), (Throwable)ioException);
        }
    }

    private static Snapshot getSnapshotById(DeltaLog deltaLog, long snapshotId, SchemaTableName schemaTableName) {
        try {
            return deltaLog.getSnapshotForVersionAsOf(snapshotId);
        }
        catch (IllegalArgumentException exception) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Snapshot version %d does not exist in Delta table '%s'.", snapshotId, schemaTableName), (Throwable)exception);
        }
    }

    private static Snapshot getSnapshotAsOfTimestamp(DeltaLog deltaLog, long snapshotAsOfTimestampMillis, SchemaTableName schemaTableName) {
        try {
            return deltaLog.getSnapshotForTimestampAsOf(snapshotAsOfTimestampMillis);
        }
        catch (IllegalArgumentException exception) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("There is no snapshot exists in Delta table '%s' that is created on or before '%s'", schemaTableName, Instant.ofEpochMilli(snapshotAsOfTimestampMillis)), (Throwable)exception);
        }
    }

    private static List<DeltaColumn> getSchema(SchemaTableName tableName, Metadata metadata) {
        Set partitionColumns = metadata.getPartitionColumns().stream().map(String::toLowerCase).collect(Collectors.toSet());
        return Arrays.stream(metadata.getSchema().getFields()).map(field -> {
            String columnName = field.getName().toLowerCase(Locale.US);
            TypeSignature prestoType = DeltaTypeUtils.convertDeltaDataTypePrestoDataType(tableName, columnName, field.getDataType());
            return new DeltaColumn(columnName, prestoType, field.isNullable(), partitionColumns.contains(columnName));
        }).collect(Collectors.toList());
    }
}

