/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class DeltaColumn {
    private final String name;
    private final TypeSignature type;
    private final boolean nullable;
    private final boolean partition;

    @JsonCreator
    public DeltaColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") TypeSignature type, @JsonProperty(value="nullable") boolean nullable, @JsonProperty(value="partition") boolean partition) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
        this.nullable = nullable;
        this.partition = partition;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isNullable() {
        return this.nullable;
    }

    @JsonProperty
    public boolean isPartition() {
        return this.partition;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.nullable, this.partition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeltaColumn other = (DeltaColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.nullable, other.nullable) && Objects.equals(this.partition, other.partition);
    }

    public String toString() {
        return this.name + ":nullable=" + this.nullable + ":partition=" + this.partition;
    }
}

