/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class DeltaColumnHandle
implements ColumnHandle {
    private final String name;
    private final TypeSignature dataType;
    private final ColumnType columnType;
    private final Optional<Subfield> subfield;

    @JsonCreator
    public DeltaColumnHandle(@JsonProperty(value="columnName") String name, @JsonProperty(value="dataType") TypeSignature dataType, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="subfield") Optional<Subfield> subfield) {
        this.name = Objects.requireNonNull(name, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.subfield = Objects.requireNonNull(subfield, "subfield is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature getDataType() {
        return this.dataType;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public Optional<Subfield> getSubfield() {
        return this.subfield;
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("dataType", (Object)this.dataType).add("columnType", (Object)this.columnType);
        if (this.subfield.isPresent()) {
            stringHelper = stringHelper.add("subfield", (Object)this.subfield.get());
        }
        return stringHelper.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaColumnHandle that = (DeltaColumnHandle)o;
        return this.name.equals(that.name) && this.dataType.equals((Object)that.dataType) && this.columnType == that.columnType && this.subfield.equals(that.subfield);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dataType, this.columnType, this.subfield});
    }

    public static Subfield getPushedDownSubfield(DeltaColumnHandle column) {
        Preconditions.checkArgument((boolean)DeltaColumnHandle.isPushedDownSubfield(column), (Object)String.format("not a valid pushed down subfield: %s", column));
        return column.getSubfield().get();
    }

    public static boolean isPushedDownSubfield(DeltaColumnHandle column) {
        return column.getColumnType() == ColumnType.SUBFIELD;
    }

    public static enum ColumnType {
        REGULAR,
        PARTITION,
        SUBFIELD;

    }
}

