/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.delta.DeltaMetadata;
import com.facebook.presto.delta.DeltaPageSourceProvider;
import com.facebook.presto.delta.DeltaSessionProperties;
import com.facebook.presto.delta.DeltaSplitManager;
import com.facebook.presto.delta.DeltaTableProperties;
import com.facebook.presto.delta.DeltaTransactionHandle;
import com.facebook.presto.delta.rule.DeltaPlanOptimizerProvider;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DeltaConnector
implements Connector {
    private static final Logger log = Logger.get(DeltaConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final DeltaMetadata metadata;
    private final DeltaSplitManager splitManager;
    private final DeltaSessionProperties sessionProperties;
    private final DeltaPageSourceProvider pageSourceProvider;
    private final DeltaPlanOptimizerProvider planOptimizerProvider;
    private final DeltaTableProperties deltaTableProperties;

    @Inject
    public DeltaConnector(LifeCycleManager lifeCycleManager, DeltaMetadata metadata, DeltaSplitManager splitManager, DeltaSessionProperties sessionProperties, DeltaPageSourceProvider pageSourceProvider, DeltaPlanOptimizerProvider planOptimizerProvider, DeltaTableProperties deltaTableProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.planOptimizerProvider = Objects.requireNonNull(planOptimizerProvider, "planOptimizerProvider is null");
        this.deltaTableProperties = Objects.requireNonNull(deltaTableProperties, "tableProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return DeltaTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)this.metadata, this.getClass().getClassLoader());
    }

    public ConnectorSplitManager getSplitManager() {
        return new ClassLoaderSafeConnectorSplitManager((ConnectorSplitManager)this.splitManager, this.getClass().getClassLoader());
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return new ClassLoaderSafeConnectorPageSourceProvider((ConnectorPageSourceProvider)this.pageSourceProvider, this.getClass().getClassLoader());
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public ConnectorPlanOptimizerProvider getConnectorPlanOptimizerProvider() {
        return this.planOptimizerProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.deltaTableProperties.getTableProperties();
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception exception) {
            log.error((Throwable)exception, "Error shutting down connector");
        }
    }
}

