/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.cache.CachingModule;
import com.facebook.presto.delta.DeltaConnectionHandleResolver;
import com.facebook.presto.delta.DeltaConnector;
import com.facebook.presto.delta.DeltaModule;
import com.facebook.presto.hive.authentication.HiveAuthenticationModule;
import com.facebook.presto.hive.gcs.HiveGcsModule;
import com.facebook.presto.hive.metastore.HiveMetastoreModule;
import com.facebook.presto.hive.s3.HiveS3Module;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "delta";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new DeltaConnectionHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new DeltaModule(catalogName, context.getTypeManager()), new HiveS3Module(catalogName), new CachingModule(), new HiveGcsModule(), new HiveAuthenticationModule(), new HiveMetastoreModule(catalogName, Optional.empty()), binder -> binder.bind(RowExpressionService.class).toInstance((Object)context.getRowExpressionService())});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            return (Connector)injector.getInstance(DeltaConnector.class);
        }
        catch (Exception exception) {
            Throwables.throwIfUnchecked((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }
}

