/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.delta.DeltaColumnHandle;
import com.facebook.presto.delta.DeltaErrorCode;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.data.CloseableIterator;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DeltaExpressionUtils {
    private DeltaExpressionUtils() {
    }

    public static List<TupleDomain<ColumnHandle>> splitPredicate(TupleDomain<ColumnHandle> predicate) {
        ImmutableMap.Builder partitionColumnPredicates = ImmutableMap.builder();
        ImmutableMap.Builder regularColumnPredicates = ImmutableMap.builder();
        Optional domains = predicate.getDomains();
        if (domains.isPresent()) {
            ((Map)domains.get()).entrySet().stream().forEach(domainPair -> {
                DeltaColumnHandle columnHandle = (DeltaColumnHandle)domainPair.getKey();
                if (columnHandle.getColumnType() == DeltaColumnHandle.ColumnType.PARTITION) {
                    partitionColumnPredicates.put(domainPair.getKey(), domainPair.getValue());
                } else {
                    regularColumnPredicates.put(domainPair.getKey(), domainPair.getValue());
                }
            });
        }
        return ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)partitionColumnPredicates.build()), (Object)TupleDomain.withColumnDomains((Map)regularColumnPredicates.build()));
    }

    public static CloseableIterator<AddFile> iterateWithPartitionPruning(final CloseableIterator<AddFile> inputIterator, TupleDomain<DeltaColumnHandle> predicate, final TypeManager typeManager) {
        final TupleDomain<String> partitionPredicate = DeltaExpressionUtils.extractPartitionColumnsPredicate(predicate);
        if (partitionPredicate.isAll()) {
            return inputIterator;
        }
        if (partitionPredicate.isNone()) {
            return new CloseableIterator<AddFile>(){

                public boolean hasNext() {
                    return false;
                }

                public AddFile next() {
                    throw new NoSuchElementException();
                }

                public void close() throws IOException {
                    inputIterator.close();
                }
            };
        }
        final List partitionColumns = ((List)predicate.getColumnDomains().get()).stream().filter(entry -> ((DeltaColumnHandle)entry.getColumn()).getColumnType() == DeltaColumnHandle.ColumnType.PARTITION).map(entry -> (DeltaColumnHandle)entry.getColumn()).collect(Collectors.toList());
        return new CloseableIterator<AddFile>(){
            private AddFile nextItem;

            public boolean hasNext() {
                if (this.nextItem != null) {
                    return true;
                }
                while (inputIterator.hasNext()) {
                    AddFile nextFile = (AddFile)inputIterator.next();
                    if (!DeltaExpressionUtils.evaluatePartitionPredicate((TupleDomain<String>)partitionPredicate, partitionColumns, typeManager, nextFile)) continue;
                    this.nextItem = nextFile;
                    break;
                }
                return this.nextItem != null;
            }

            public AddFile next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("there are no more files");
                }
                AddFile toReturn = this.nextItem;
                this.nextItem = null;
                return toReturn;
            }

            public void close() throws IOException {
                inputIterator.close();
            }
        };
    }

    private static TupleDomain<String> extractPartitionColumnsPredicate(TupleDomain<DeltaColumnHandle> predicate) {
        return predicate.transform(deltaColumnHandle -> {
            if (deltaColumnHandle.getColumnType() != DeltaColumnHandle.ColumnType.PARTITION) {
                return null;
            }
            return deltaColumnHandle.getName();
        });
    }

    private static boolean evaluatePartitionPredicate(TupleDomain<String> partitionPredicate, List<DeltaColumnHandle> partitionColumns, TypeManager typeManager, AddFile addFile) {
        Preconditions.checkArgument((!partitionPredicate.isNone() ? 1 : 0) != 0, (Object)"Expecting a predicate with at least one expression");
        for (DeltaColumnHandle partitionColumn : partitionColumns) {
            String columnName = partitionColumn.getName();
            String partitionValue = (String)addFile.getPartitionValues().get(columnName);
            Domain domain = DeltaExpressionUtils.getDomain(partitionColumn, partitionValue, typeManager, addFile.getPath());
            Domain columnPredicate = (Domain)((Map)partitionPredicate.getDomains().get()).get(columnName);
            if (columnPredicate == null || !columnPredicate.intersect(domain).isNone()) continue;
            return false;
        }
        return true;
    }

    private static Domain getDomain(DeltaColumnHandle columnHandle, String partitionValue, TypeManager typeManager, String filePath) {
        Type type = typeManager.getType(columnHandle.getDataType());
        if (partitionValue == null) {
            return Domain.onlyNull((Type)type);
        }
        String typeBase = columnHandle.getDataType().getBase();
        try {
            switch (typeBase) {
                case "tinyint": 
                case "smallint": 
                case "integer": 
                case "bigint": {
                    Long intValue = Long.parseLong(partitionValue);
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)intValue, (Object[])new Object[0]), (boolean)false);
                }
                case "real": {
                    Long realValue = Float.floatToRawIntBits(Float.parseFloat(partitionValue));
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)realValue, (Object[])new Object[0]), (boolean)false);
                }
                case "double": {
                    Long doubleValue = Double.doubleToRawLongBits(Double.parseDouble(partitionValue));
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)doubleValue, (Object[])new Object[0]), (boolean)false);
                }
                case "varchar": 
                case "varbinary": {
                    Slice sliceValue = Slices.utf8Slice((String)partitionValue);
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)sliceValue, (Object[])new Object[0]), (boolean)false);
                }
                case "date": {
                    Long dateValue = Date.valueOf(partitionValue).getTime();
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)dateValue, (Object[])new Object[0]), (boolean)false);
                }
                case "timestamp": {
                    Long timestampValue = Timestamp.valueOf(partitionValue).getTime();
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)timestampValue, (Object[])new Object[0]), (boolean)false);
                }
                case "boolean": {
                    Boolean booleanValue = Boolean.valueOf(partitionValue);
                    return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)booleanValue, (Object[])new Object[0]), (boolean)false);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_UNSUPPORTED_COLUMN_TYPE, String.format("Unsupported data type '%s' for partition column %s", columnHandle.getDataType(), columnHandle.getName()));
        }
        catch (IllegalArgumentException exception) {
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_INVALID_PARTITION_VALUE, String.format("Can not parse partition value '%s' of type '%s' for partition column '%s' in file '%s'", partitionValue, columnHandle.getDataType(), columnHandle.getName(), filePath), (Throwable)exception);
        }
    }
}

