/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.delta.DeltaClient;
import com.facebook.presto.delta.DeltaColumn;
import com.facebook.presto.delta.DeltaColumnHandle;
import com.facebook.presto.delta.DeltaConfig;
import com.facebook.presto.delta.DeltaConnectorId;
import com.facebook.presto.delta.DeltaExpressionUtils;
import com.facebook.presto.delta.DeltaTable;
import com.facebook.presto.delta.DeltaTableHandle;
import com.facebook.presto.delta.DeltaTableLayoutHandle;
import com.facebook.presto.delta.DeltaTableName;
import com.facebook.presto.delta.DeltaTableProperties;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DeltaMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(DeltaMetadata.class);
    private static final String PATH_SCHEMA = "$PATH$";
    private final String connectorId;
    private final DeltaClient deltaClient;
    private final ExtendedHiveMetastore metastore;
    private final TypeManager typeManager;
    private final DeltaConfig config;

    @Inject
    public DeltaMetadata(DeltaConnectorId connectorId, DeltaClient deltaClient, ExtendedHiveMetastore metastore, TypeManager typeManager, DeltaConfig config) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.deltaClient = Objects.requireNonNull(deltaClient, "deltaClient is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.addAll(this.metastore.getAllDatabases(this.metastoreContext(session)));
        schemas.add(PATH_SCHEMA.toLowerCase(Locale.US));
        return schemas;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        PrestoTableType tableType = DeltaTableProperties.isExternalTable(tableMetadata.getProperties()) ? PrestoTableType.EXTERNAL_TABLE : PrestoTableType.MANAGED_TABLE;
        Table table = this.prepareTable(session, tableMetadata, tableType);
        PrincipalPrivileges principalPrivileges = DeltaMetadata.buildInitialPrivilegeSet(table.getOwner());
        this.metastore.createTable(this.metastoreContext(session), table, principalPrivileges);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaTableHandle handle = (DeltaTableHandle)tableHandle;
        MetastoreContext metastoreContext = this.metastoreContext(session);
        Optional target = this.metastore.getTable(metastoreContext, handle.getDeltaTable().getSchemaName(), handle.getDeltaTable().getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.toSchemaTableName());
        }
        this.metastore.dropTable(metastoreContext, handle.getDeltaTable().getSchemaName(), handle.getDeltaTable().getTableName(), false);
    }

    private static PrincipalPrivileges buildInitialPrivilegeSet(String tableOwner) {
        PrestoPrincipal owner = new PrestoPrincipal(PrincipalType.USER, tableOwner);
        return new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).build(), (Multimap)ImmutableMultimap.of());
    }

    private Table prepareTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, PrestoTableType tableType) {
        String schemaName = tableMetadata.getTable().getSchemaName();
        String tableName = tableMetadata.getTable().getTableName();
        if (!tableType.equals((Object)PrestoTableType.EXTERNAL_TABLE)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create managed Delta table");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(session.getUser()).setTableType(tableType);
        Map tableProperties = tableMetadata.getProperties();
        HiveStorageFormat hiveStorageFormat = DeltaTableProperties.getTableStorageFormat(tableMetadata.getProperties());
        String tableLocation = tableProperties.get("external_location").toString();
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)hiveStorageFormat)).setLocation(tableLocation);
        return tableBuilder.build();
    }

    public DeltaTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        String tableLocation;
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        if (!this.listSchemaNames(session).contains(schemaName)) {
            return null;
        }
        DeltaTableName deltaTableName = DeltaTableName.from(tableName);
        if (PATH_SCHEMA.equalsIgnoreCase(schemaName)) {
            tableLocation = deltaTableName.getTableNameOrPath();
        } else {
            Optional metastoreTable = this.metastore.getTable(this.metastoreContext(session), schemaName, deltaTableName.getTableNameOrPath());
            if (!metastoreTable.isPresent()) {
                return null;
            }
            Map tableParameters = ((Table)metastoreTable.get()).getParameters();
            Storage storage = ((Table)metastoreTable.get()).getStorage();
            tableLocation = storage.getLocation();
            if ("delta".equalsIgnoreCase((String)tableParameters.get("spark.sql.sources.provider")) && Strings.isNullOrEmpty((String)(tableLocation = (String)storage.getSerdeParameters().get("path")))) {
                log.warn("Location key ('path') is missing in SerDe properties for table %s. Using the 'location' attribute as the table location.", new Object[]{schemaTableName});
                tableLocation = storage.getLocation();
            }
        }
        Optional<DeltaTable> table = this.deltaClient.getTable(session, schemaTableName, tableLocation, deltaTableName.getSnapshotId(), deltaTableName.getTimestampMillisUtc());
        if (table.isPresent()) {
            return new DeltaTableHandle(this.connectorId, table.get());
        }
        return null;
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        DeltaTableHandle tableHandle = (DeltaTableHandle)table;
        List<TupleDomain<ColumnHandle>> predicate = DeltaExpressionUtils.splitPredicate((TupleDomain<ColumnHandle>)constraint.getSummary());
        TupleDomain<ColumnHandle> unenforcedPredicate = predicate.get(1);
        DeltaTableLayoutHandle newDeltaTableLayoutHandle = new DeltaTableLayoutHandle(tableHandle, (TupleDomain<DeltaColumnHandle>)constraint.getSummary().transform(DeltaColumnHandle.class::cast), Optional.of(constraint.getSummary().toString(session.getSqlFunctionProperties())));
        ConnectorTableLayout newLayout = new ConnectorTableLayout((ConnectorTableLayoutHandle)newDeltaTableLayoutHandle, Optional.empty(), constraint.getSummary(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(newLayout, unenforcedPredicate));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        DeltaTableHandle deltaTableHandle = (DeltaTableHandle)table;
        this.checkConnectorId(deltaTableHandle);
        return this.getTableMetadata(session, deltaTableHandle.toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        List<String> schemaNames = schemaName.map(ImmutableList::of).orElse(this.listSchemaNames(session));
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schema : schemaNames) {
            for (String tableName : this.metastore.getAllTables(this.metastoreContext(session), schema).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schema, tableName));
            }
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaTableHandle deltaTableHandle = (DeltaTableHandle)tableHandle;
        this.checkConnectorId(deltaTableHandle);
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (DeltaColumn column : deltaTableHandle.getDeltaTable().getColumns()) {
            columnHandles.put((Object)column.getName(), (Object)new DeltaColumnHandle(column.getName(), column.getType(), column.isPartition() ? DeltaColumnHandle.ColumnType.PARTITION : DeltaColumnHandle.ColumnType.REGULAR, Optional.empty()));
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        DeltaTableHandle tableHandle = this.getTableHandle(session, tableName);
        if (tableHandle == null) {
            return null;
        }
        List columnMetadata = tableHandle.getDeltaTable().getColumns().stream().map(column -> this.getColumnMetadata((DeltaColumn)column)).collect(Collectors.toList());
        return new ConnectorTableMetadata(tableName, columnMetadata);
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return this.getColumnMetadata(columnHandle);
    }

    private ColumnMetadata getColumnMetadata(ColumnHandle columnHandle) {
        DeltaColumnHandle deltaColumnHandle = (DeltaColumnHandle)columnHandle;
        return new ColumnMetadata(deltaColumnHandle.getName(), this.typeManager.getType(deltaColumnHandle.getDataType()));
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchemaName() == null) {
            return this.listTables(session, prefix.getSchemaName());
        }
        return ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
    }

    private ColumnMetadata getColumnMetadata(DeltaColumn deltaColumn) {
        return new ColumnMetadata(deltaColumn.getName(), this.typeManager.getType(deltaColumn.getType()));
    }

    private MetastoreContext metastoreContext(ConnectorSession session) {
        return new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
    }

    private void checkConnectorId(DeltaTableHandle tableHandle) {
        Preconditions.checkArgument((boolean)tableHandle.getConnectorId().equals(this.connectorId), (Object)"table handle is not for this connector");
    }
}

