/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.Utils;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.delta.DeltaColumnHandle;
import com.facebook.presto.delta.DeltaErrorCode;
import com.facebook.presto.delta.DeltaPageSource;
import com.facebook.presto.delta.DeltaSessionProperties;
import com.facebook.presto.delta.DeltaSplit;
import com.facebook.presto.delta.DeltaTableHandle;
import com.facebook.presto.delta.DeltaTableLayoutHandle;
import com.facebook.presto.delta.DeltaTypeUtils;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class DeltaPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;

    @Inject
    public DeltaPageSourceProvider(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, FileFormatDataSourceStats fileFormatDataSourceStats) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns, SplitContext splitContext) {
        DeltaSplit deltaSplit = (DeltaSplit)split;
        DeltaTableLayoutHandle deltaTableLayoutHandle = (DeltaTableLayoutHandle)layout;
        DeltaTableHandle deltaTableHandle = deltaTableLayoutHandle.getTable();
        HdfsContext hdfsContext = new HdfsContext(session, deltaSplit.getSchema(), deltaSplit.getTable(), deltaSplit.getFilePath(), false);
        Path filePath = new Path(deltaSplit.getFilePath());
        List<DeltaColumnHandle> deltaColumnHandles = columns.stream().map(DeltaColumnHandle.class::cast).collect(Collectors.toList());
        List<DeltaColumnHandle> regularColumnHandles = deltaColumnHandles.stream().filter(columnHandle -> columnHandle.getColumnType() != DeltaColumnHandle.ColumnType.PARTITION).collect(Collectors.toList());
        ConnectorPageSource dataPageSource = DeltaPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session, this.hdfsEnvironment.getConfiguration(hdfsContext, filePath), filePath, deltaSplit.getStart(), deltaSplit.getLength(), deltaSplit.getFileSize(), regularColumnHandles, deltaTableHandle.toSchemaTableName(), this.typeManager, deltaTableLayoutHandle.getPredicate(), this.fileFormatDataSourceStats);
        return new DeltaPageSource(deltaColumnHandles, this.convertPartitionValues(deltaColumnHandles, deltaSplit.getPartitionValues()), dataPageSource);
    }

    private Map<String, Block> convertPartitionValues(List<DeltaColumnHandle> allColumns, Map<String, String> partitionValues) {
        return allColumns.stream().filter(columnHandle -> columnHandle.getColumnType() == DeltaColumnHandle.ColumnType.PARTITION).collect(Collectors.toMap(DeltaColumnHandle::getName, columnHandle -> {
            com.facebook.presto.common.type.Type columnType = this.typeManager.getType(columnHandle.getDataType());
            return Utils.nativeValueToBlock((com.facebook.presto.common.type.Type)columnType, (Object)DeltaTypeUtils.convertPartitionValue(columnHandle.getName(), (String)partitionValues.get(columnHandle.getName()), columnType));
        }));
    }

    private static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, Path path, long start, long length, long fileSize, List<DeltaColumnHandle> columns, SchemaTableName tableName, TypeManager typeManager, TupleDomain<DeltaColumnHandle> effectivePredicate, FileFormatDataSourceStats stats) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        String user = session.getUser();
        boolean readMaskedValue = DeltaSessionProperties.getReadNullMaskedParquetEncryptedValue(session);
        HdfsParquetDataSource dataSource = null;
        try {
            HdfsParquetDataSource parquetDataSource;
            ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(fileSize), OptionalLong.of(start), OptionalLong.of(length), fileStatus.getModificationTime(), false);
            FSDataInputStream inputStream = fileSystem.openFile(path, hiveFileContext);
            dataSource = parquetDataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (FileFormatDataSourceStats)stats);
            Optional fileDecryptor = ParquetPageSourceFactory.createDecryptor((Configuration)configuration, (Path)path);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(user, () -> DeltaPageSourceProvider.lambda$createParquetPageSource$3((ParquetDataSource)parquetDataSource, fileSize, fileDecryptor, readMaskedValue));
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Optional<MessageType> message = columns.stream().filter(column -> column.getColumnType() == DeltaColumnHandle.ColumnType.REGULAR || DeltaColumnHandle.isPushedDownSubfield(column)).map(column -> DeltaPageSourceProvider.getColumnType(typeManager.getType(column.getDataType()), fileSchema, column, tableName, path)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new Type[]{type})).reduce(MessageType::union);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            ImmutableList.Builder footerBlocks = ImmutableList.builder();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage;
                Optional firstIndex = MetadataReader.findFirstNonHiddenColumnId((BlockMetaData)block);
                if (!firstIndex.isPresent() || (firstDataPage = ((ColumnChunkMetaData)block.getColumns().get((Integer)firstIndex.get())).getFirstDataPageOffset()) < start || firstDataPage >= start + length) continue;
                footerBlocks.add((Object)block);
            }
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = DeltaPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            HdfsParquetDataSource finalDataSource = dataSource;
            ImmutableList.Builder blocks = ImmutableList.builder();
            ArrayList<Object> blockIndexStores = new ArrayList<Object>();
            for (BlockMetaData block : footerBlocks.build()) {
                Optional columnIndexStore;
                if (!PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)finalDataSource, (Map)descriptorsByPath, parquetTupleDomain, (Optional)(columnIndexStore = ColumnIndexFilterUtils.getColumnIndexStore((Predicate)parquetPredicate, (ParquetDataSource)finalDataSource, (BlockMetaData)block, (Map)descriptorsByPath, (boolean)false)), (boolean)false, Optional.of(session.getWarningCollector()))) continue;
                blocks.add((Object)block);
                blockIndexStores.add(columnIndexStore.orElse(null));
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, (List)blocks.build(), Optional.empty(), (ParquetDataSource)dataSource, systemMemoryContext, DeltaSessionProperties.getParquetMaxReadBlockSize(session), DeltaSessionProperties.isParquetBatchReadsEnabled(session), DeltaSessionProperties.isParquetBatchReaderVerificationEnabled(session), parquetPredicate, blockIndexStores, false, fileDecryptor);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            for (DeltaColumnHandle column2 : columns) {
                Preconditions.checkArgument((column2.getColumnType() == DeltaColumnHandle.ColumnType.REGULAR || column2.getColumnType() == DeltaColumnHandle.ColumnType.SUBFIELD ? 1 : 0) != 0, (Object)"column type must be regular or subfield column");
                String name = column2.getName();
                com.facebook.presto.common.type.Type type2 = typeManager.getType(column2.getDataType());
                namesBuilder.add((Object)name);
                typesBuilder.add((Object)type2);
                if (DeltaColumnHandle.isPushedDownSubfield(column2)) {
                    Subfield pushedDownSubfield = DeltaColumnHandle.getPushedDownSubfield(column2);
                    List nestedColumnPath = ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield);
                    Optional columnIO = ColumnIOConverter.findNestedColumnIO((ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumnIO, (String)pushedDownSubfield.getRootName()), (List)nestedColumnPath);
                    if (columnIO.isPresent()) {
                        fieldsBuilder.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)type2, (ColumnIO)((ColumnIO)columnIO.get())));
                        continue;
                    }
                    fieldsBuilder.add(Optional.empty());
                    continue;
                }
                if (DeltaPageSourceProvider.getParquetType(type2, fileSchema, column2, tableName, path).isPresent()) {
                    fieldsBuilder.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)type2, (ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumnIO, (String)name)));
                    continue;
                }
                fieldsBuilder.add(Optional.empty());
            }
            return new ParquetPageSource(parquetReader, (List)typesBuilder.build(), (List)fieldsBuilder.build(), (List)namesBuilder.build(), new RuntimeStats());
        }
        catch (Exception exception) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileStatus) {
                // empty catch block
            }
            if (exception instanceof PrestoException) {
                throw (PrestoException)((Object)exception);
            }
            if (exception instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_BAD_DATA, (Throwable)exception);
            }
            if (exception instanceof AccessControlException) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, exception.getMessage(), (Throwable)exception);
            }
            if (Strings.nullToEmpty((String)exception.getMessage()).trim().equals("Filesystem closed") || exception instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_CANNOT_OPEN_SPLIT, (Throwable)exception);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, exception.getMessage());
            if (exception.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_MISSING_DATA, message, (Throwable)exception);
            }
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_CANNOT_OPEN_SPLIT, message, (Throwable)exception);
        }
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<DeltaColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            RichColumnDescriptor descriptor;
            DeltaColumnHandle columnHandle = (DeltaColumnHandle)entry.getKey();
            if (DeltaColumnHandle.isPushedDownSubfield(columnHandle)) {
                Subfield pushedDownSubfield = DeltaColumnHandle.getPushedDownSubfield(columnHandle);
                List subfieldPath = ParquetTypeUtils.columnPathFromSubfield((Subfield)pushedDownSubfield);
                descriptor = descriptorsByPath.get(subfieldPath);
            } else {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()));
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, entry.getValue());
        }
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    public static Optional<Type> getParquetType(com.facebook.presto.common.type.Type prestoType, MessageType messageType, DeltaColumnHandle column, SchemaTableName tableName, Path path) {
        Type type = ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)messageType);
        if (type == null) {
            return Optional.empty();
        }
        if (!ParquetPageSourceFactory.checkSchemaMatch((Type)type, (com.facebook.presto.common.type.Type)prestoType)) {
            String parquetTypeName;
            if (type.isPrimitive()) {
                parquetTypeName = type.asPrimitiveType().getPrimitiveTypeName().toString();
            } else {
                GroupType group = type.asGroupType();
                StringBuilder builder = new StringBuilder();
                group.writeToStringBuilder(builder, "");
                parquetTypeName = builder.toString();
            }
            throw new PrestoException((ErrorCodeSupplier)DeltaErrorCode.DELTA_PARQUET_SCHEMA_MISMATCH, String.format("The column %s of table %s is declared as type %s, but the Parquet file (%s) declares the column as type %s", column.getName(), tableName.toString(), column.getDataType(), path.toString(), parquetTypeName));
        }
        return Optional.of(type);
    }

    public static Optional<Type> getColumnType(com.facebook.presto.common.type.Type prestoType, MessageType messageType, DeltaColumnHandle column, SchemaTableName tableName, Path path) {
        if (DeltaColumnHandle.isPushedDownSubfield(column)) {
            Subfield pushedDownSubfield = DeltaColumnHandle.getPushedDownSubfield(column);
            return ParquetTypeUtils.getSubfieldType((GroupType)messageType, (String)pushedDownSubfield.getRootName(), (List)ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield));
        }
        return DeltaPageSourceProvider.getParquetType(prestoType, messageType, column, tableName, path);
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$3(ParquetDataSource parquetDataSource, long fileSize, Optional fileDecryptor, boolean readMaskedValue) throws IOException {
        return MetadataReader.readFooter((ParquetDataSource)parquetDataSource, (long)fileSize, (Optional)fileDecryptor, (boolean)readMaskedValue).getParquetMetadata();
    }
}

