/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.delta.DeltaConfig;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public final class DeltaSessionProperties {
    private static final String CACHE_ENABLED = "cache_enabled";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_BATCH_READ_OPTIMIZATION_ENABLED = "parquet_batch_read_optimization_enabled";
    private static final String PARQUET_BATCH_READER_VERIFICATION_ENABLED = "parquet_batch_reader_verification_enabled";
    public static final String PARQUET_DEREFERENCE_PUSHDOWN_ENABLED = "parquet_dereference_pushdown_enabled";
    public static final String READ_MASKED_VALUE_ENABLED = "read_null_masked_parquet_encrypted_value_enabled";
    private static final String NODE_SELECTION_STRATEGY = "node_selection_strategy";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public DeltaSessionProperties(DeltaConfig deltaConfigConfig, HiveClientConfig hiveClientConfig, CacheConfig cacheConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)CACHE_ENABLED, (String)"Enable cache for Delta tables", (Boolean)cacheConfig.isCachingEnabled(), (boolean)false), (Object)new PropertyMetadata(NODE_SELECTION_STRATEGY, "Node affinity selection strategy", (Type)VarcharType.VARCHAR, NodeSelectionStrategy.class, (Object)hiveClientConfig.getNodeSelectionStrategy(), false, value -> NodeSelectionStrategy.valueOf((String)((String)value).toUpperCase()), Enum::toString), (Object)HiveSessionProperties.dataSizeSessionProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)hiveClientConfig.getParquetMaxReadBlockSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, (String)"Is Parquet batch read optimization enabled", (Boolean)hiveClientConfig.isParquetBatchReadOptimizationEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READER_VERIFICATION_ENABLED, (String)"Is Parquet batch reader verification enabled? This is for testing purposes only, not to be used in production", (Boolean)hiveClientConfig.isParquetBatchReaderVerificationEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, (String)"Is dereference pushdown expression pushdown into Parquet reader enabled?", (Boolean)deltaConfigConfig.isParquetDereferencePushdownEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)READ_MASKED_VALUE_ENABLED, (String)"Return null when access is denied for an encrypted parquet column", (Boolean)hiveClientConfig.getReadNullMaskedParquetEncryptedValue(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(CACHE_ENABLED, Boolean.class);
    }

    public static NodeSelectionStrategy getNodeSelectionStrategy(ConnectorSession session) {
        return (NodeSelectionStrategy)session.getProperty(NODE_SELECTION_STRATEGY, NodeSelectionStrategy.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean isParquetBatchReadsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, Boolean.class);
    }

    public static boolean isParquetBatchReaderVerificationEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READER_VERIFICATION_ENABLED, Boolean.class);
    }

    public static boolean isParquetDereferencePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_DEREFERENCE_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean getReadNullMaskedParquetEncryptedValue(ConnectorSession session) {
        return (Boolean)session.getProperty(READ_MASKED_VALUE_ENABLED, Boolean.class);
    }
}

