/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;

public class DeltaSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String schema;
    private final String table;
    private final String filePath;
    private final long start;
    private final long length;
    private final long fileSize;
    private final Map<String, String> partitionValues;
    private final NodeSelectionStrategy nodeSelectionStrategy;

    @JsonCreator
    public DeltaSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schema, @JsonProperty(value="tableName") String table, @JsonProperty(value="filePath") String filePath, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="partitionValues") Map<String, String> partitionValues, @JsonProperty(value="nodeSelectionStrategy") NodeSelectionStrategy nodeSelectionStrategy) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (Object)"fileSize must be positive");
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.schema = Objects.requireNonNull(schema, "schema name is null");
        this.table = Objects.requireNonNull(table, "table name is null");
        this.filePath = Objects.requireNonNull(filePath, "filePath name is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.partitionValues = ImmutableMap.copyOf(Objects.requireNonNull(partitionValues, "partitionValues id is null"));
        this.nodeSelectionStrategy = nodeSelectionStrategy;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getFilePath() {
        return this.filePath;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        if (this.getNodeSelectionStrategy() == NodeSelectionStrategy.SOFT_AFFINITY) {
            return nodeProvider.get(this.filePath, 2);
        }
        return ImmutableList.of();
    }

    public OptionalLong getSplitSizeInBytes() {
        return OptionalLong.of(this.length);
    }

    public Object getInfo() {
        return this;
    }
}

