/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.delta.DeltaClient;
import com.facebook.presto.delta.DeltaConfig;
import com.facebook.presto.delta.DeltaConnectorId;
import com.facebook.presto.delta.DeltaExpressionUtils;
import com.facebook.presto.delta.DeltaSessionProperties;
import com.facebook.presto.delta.DeltaSplit;
import com.facebook.presto.delta.DeltaTable;
import com.facebook.presto.delta.DeltaTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import io.delta.standalone.actions.AddFile;
import io.delta.standalone.data.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class DeltaSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final DeltaConfig deltaConfig;
    private final DeltaClient deltaClient;
    private final TypeManager typeManager;

    @Inject
    public DeltaSplitManager(DeltaConnectorId connectorId, DeltaConfig deltaConfig, DeltaClient deltaClient, TypeManager typeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.deltaConfig = Objects.requireNonNull(deltaConfig, "deltaConfig is null");
        this.deltaClient = Objects.requireNonNull(deltaClient, "deltaClient is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle handle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        return new DeltaSplitSource(session, (DeltaTableLayoutHandle)layout);
    }

    private static Map<String, String> removeNullPartitionValues(Map<String, String> partitionValues) {
        return partitionValues.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private class DeltaSplitSource
    implements ConnectorSplitSource {
        private final DeltaTable deltaTable;
        private final CloseableIterator<AddFile> fileIterator;
        private final int maxBatchSize;
        private final ConnectorSession session;

        DeltaSplitSource(ConnectorSession session, DeltaTableLayoutHandle deltaTableHandle) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.deltaTable = deltaTableHandle.getTable().getDeltaTable();
            this.fileIterator = DeltaExpressionUtils.iterateWithPartitionPruning(DeltaSplitManager.this.deltaClient.listFiles(session, this.deltaTable), deltaTableHandle.getPredicate(), DeltaSplitManager.this.typeManager);
            this.maxBatchSize = DeltaSplitManager.this.deltaConfig.getMaxSplitsBatchSize();
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            ImmutableList.Builder splitBuilder = ImmutableList.builder();
            for (long currentSplitCount = 0L; this.fileIterator.hasNext() && currentSplitCount < (long)maxSize && currentSplitCount < (long)this.maxBatchSize; ++currentSplitCount) {
                AddFile file = (AddFile)this.fileIterator.next();
                Path filePath = new Path(this.deltaTable.getTableLocation(), URI.create(file.getPath()).getPath());
                splitBuilder.add((Object)new DeltaSplit(DeltaSplitManager.this.connectorId, this.deltaTable.getSchemaName(), this.deltaTable.getTableName(), filePath.toString(), 0L, file.getSize(), file.getSize(), DeltaSplitManager.removeNullPartitionValues(file.getPartitionValues()), DeltaSessionProperties.getNodeSelectionStrategy(this.session)));
            }
            return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch((List)splitBuilder.build(), !this.fileIterator.hasNext()));
        }

        public void close() {
            try {
                this.fileIterator.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public boolean isFinished() {
            return !this.fileIterator.hasNext();
        }
    }
}

