/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.delta.DeltaColumn;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeltaTable {
    private final String schemaName;
    private final String tableName;
    private final String tableLocation;
    private final Optional<Long> snapshotId;
    private final List<DeltaColumn> columns;

    @JsonCreator
    public DeltaTable(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableLocation") String tableLocation, @JsonProperty(value="snapshotId") Optional<Long> snapshotId, @JsonProperty(value="columns") List<DeltaColumn> columns) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (Object)"schemaName is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTableLocation() {
        return this.tableLocation;
    }

    @JsonProperty
    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    @JsonProperty
    public List<DeltaColumn> getColumns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaTable that = (DeltaTable)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableLocation, that.tableLocation) && Objects.equals(this.snapshotId, that.snapshotId) && Objects.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.tableLocation, this.snapshotId, this.columns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)(this.schemaName + "." + this.tableName)).add("location", (Object)this.tableLocation).add("snapshotId", this.snapshotId).add("columns", this.columns).toString();
    }

    public static enum DataFormat {
        PARQUET,
        ORC;

    }
}

