/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.delta.DeltaTable;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class DeltaTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final DeltaTable deltaTable;

    @JsonCreator
    public DeltaTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="deltaTable") DeltaTable deltaTable) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.deltaTable = Objects.requireNonNull(deltaTable, "deltaTable is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public DeltaTable getDeltaTable() {
        return this.deltaTable;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.deltaTable.getSchemaName(), this.deltaTable.getTableName());
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.deltaTable);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeltaTableHandle other = (DeltaTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.deltaTable, other.deltaTable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("table", (Object)this.toSchemaTableName()).toString();
    }
}

