/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.delta;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;

public class DeltaTableProperties {
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public DeltaTableProperties(TypeManager typeManager, HiveClientConfig config) {
        this.tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)"File system location URI for external table", null, (boolean)false), (Object)new PropertyMetadata(STORAGE_FORMAT_PROPERTY, "Hive storage format for the table", (Type)VarcharType.createUnboundedVarcharType(), HiveStorageFormat.class, (Object)config.getHiveStorageFormat(), false, value -> HiveStorageFormat.valueOf((String)((String)value).toUpperCase(Locale.ENGLISH)), Enum::toString));
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static boolean isExternalTable(Map<String, Object> tableProperties) {
        return tableProperties.get(EXTERNAL_LOCATION_PROPERTY) != null;
    }

    public static HiveStorageFormat getTableStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)tableProperties.get(STORAGE_FORMAT_PROPERTY);
    }
}

