/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.json.ObjectMapperProvider;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.druid.DruidClient;
import com.facebook.presto.druid.DruidColumnHandle;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidQueryGenerator;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DruidBrokerPageSource
implements ConnectorPageSource {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final List<ColumnHandle> columnHandles;
    private boolean finished;
    private long readTimeNanos;
    private long completedBytes;
    private long completedPositions;
    private BufferedReader responseStream;
    private final PageBuilder pageBuilder;
    private List<Type> columnTypes;

    public DruidBrokerPageSource(DruidQueryGenerator.GeneratedDql brokerDql, List<ColumnHandle> columnHandles, DruidClient druidClient) {
        Objects.requireNonNull(brokerDql, "broker is null");
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        Objects.requireNonNull(druidClient, "druid client is null");
        this.responseStream = new BufferedReader(new InputStreamReader(druidClient.getData(brokerDql.getDql())));
        List handles = (List)columnHandles.stream().map(column -> (DruidColumnHandle)column).collect(ImmutableList.toImmutableList());
        this.columnTypes = (List)handles.stream().map(DruidColumnHandle::getColumnType).collect(ImmutableList.toImmutableList());
        this.pageBuilder = new PageBuilder(this.columnTypes);
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        if (this.finished) {
            return null;
        }
        long start = System.nanoTime();
        try {
            JsonNode rootNode;
            String readLine;
            while ((readLine = this.responseStream.readLine()) != null) {
                if (readLine.isEmpty()) {
                    this.finished = true;
                    break;
                }
                rootNode = OBJECT_MAPPER.readTree(readLine);
                if (!(rootNode instanceof ArrayNode)) {
                    if (rootNode instanceof ObjectNode) {
                        throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, ((ObjectNode)rootNode).findValue("errorMessage").asText());
                    }
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, rootNode.toString());
                }
                ArrayNode arrayNode = (ArrayNode)rootNode;
                for (int i = 0; i < this.columnHandles.size(); ++i) {
                    Type type = this.columnTypes.get(i);
                    BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(i);
                    JsonNode value = arrayNode.get(i);
                    if (value == null) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    if (type instanceof BigintType) {
                        type.writeLong(blockBuilder, value.longValue());
                        continue;
                    }
                    if (type instanceof DoubleType) {
                        type.writeDouble(blockBuilder, value.doubleValue());
                        continue;
                    }
                    if (type instanceof RealType) {
                        type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(value.floatValue()));
                        continue;
                    }
                    if (type instanceof TimestampType) {
                        DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser().withChronology((Chronology)ISOChronology.getInstanceUTC()).withOffsetParsed();
                        DateTime dateTime = formatter.parseDateTime(value.textValue());
                        type.writeLong(blockBuilder, dateTime.getMillis());
                        continue;
                    }
                    Slice slice = Slices.utf8Slice((String)value.textValue());
                    type.writeSlice(blockBuilder, slice);
                }
                this.pageBuilder.declarePosition();
                if (!this.pageBuilder.isFull()) continue;
            }
            if (readLine == null) {
                this.finished = true;
                rootNode = null;
                return rootNode;
            }
            if (this.pageBuilder.isEmpty() || !this.finished && !this.pageBuilder.isFull()) {
                rootNode = null;
                return rootNode;
            }
            Page page = this.pageBuilder.build();
            this.completedPositions += (long)page.getPositionCount();
            this.completedBytes += page.getSizeInBytes();
            this.pageBuilder.reset();
            Page page2 = page;
            return page2;
        }
        catch (IOException e) {
            this.finished = true;
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, "Parse druid client response error", (Throwable)e);
        }
        finally {
            this.readTimeNanos += System.nanoTime() - start;
        }
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.finished = true;
    }
}

