/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.druid.DruidConnector;
import com.facebook.presto.druid.DruidHandleResolver;
import com.facebook.presto.druid.DruidModule;
import com.facebook.presto.druid.authentication.DruidAuthenticationModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class DruidConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "druid";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new DruidHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new DruidModule(), new DruidAuthenticationModule(), binder -> {
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(FunctionMetadataManager.class).toInstance((Object)context.getFunctionMetadataManager());
                binder.bind(RowExpressionService.class).toInstance((Object)context.getRowExpressionService());
                binder.bind(StandardFunctionResolution.class).toInstance((Object)context.getStandardFunctionResolution());
                binder.bind(DeterminismEvaluator.class).toInstance((Object)context.getRowExpressionService().getDeterminismEvaluator());
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(DruidConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

