/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.zip.ExtraDataList;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import javax.annotation.Nullable;

public class ZipFileEntry {
    private String name;
    private long time = -1L;
    private long crc = -1L;
    private long size = -1L;
    private long csize = -1L;
    private Compression method;
    private short version = (short)-1;
    private short versionNeeded = (short)-1;
    private short flags;
    private short internalAttributes;
    private int externalAttributes;
    private long localHeaderOffset = -1L;
    private ExtraDataList extra;
    @Nullable
    private String comment;
    private EnumSet<Feature> featureSet;

    public ZipFileEntry(String name) {
        this.featureSet = EnumSet.of(Feature.DEFAULT);
        this.setName(name);
        this.setMethod(Compression.STORED);
        this.setExtra(new ExtraDataList());
    }

    public ZipFileEntry(ZipFileEntry e) {
        this.name = e.getName();
        this.time = e.getTime();
        this.crc = e.getCrc();
        this.size = e.getSize();
        this.csize = e.getCompressedSize();
        this.method = e.getMethod();
        this.version = e.getVersion();
        this.versionNeeded = e.getVersionNeeded();
        this.flags = e.getFlags();
        this.internalAttributes = e.getInternalAttributes();
        this.externalAttributes = e.getExternalAttributes();
        this.localHeaderOffset = e.getLocalHeaderOffset();
        this.extra = new ExtraDataList(e.getExtra());
        this.comment = e.getComment();
        this.featureSet = EnumSet.copyOf(e.getFeatureSet());
    }

    public void setName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Zip file name could not be null");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setCrc(long crc) {
        if (crc < 0L || crc > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        if (size > 0xFFFFFFFFL) {
            this.featureSet.add(Feature.ZIP64_SIZE);
        } else {
            this.featureSet.remove((Object)Feature.ZIP64_SIZE);
        }
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setCompressedSize(long csize) {
        if (csize < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        if (csize > 0xFFFFFFFFL) {
            this.featureSet.add(Feature.ZIP64_CSIZE);
        } else {
            this.featureSet.remove((Object)Feature.ZIP64_CSIZE);
        }
        this.csize = csize;
    }

    public long getCompressedSize() {
        return this.csize;
    }

    public void setMethod(Compression method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"Zip file compression could not be null");
        if (this.method != null) {
            this.featureSet.remove((Object)this.method.getFeature());
        }
        this.method = method;
        this.featureSet.add(this.method.getFeature());
    }

    public Compression getMethod() {
        return this.method;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getVersion() {
        return (short)Math.max(this.version, Feature.getMinRequiredVersion(this.featureSet));
    }

    public void setVersionNeeded(short versionNeeded) {
        this.versionNeeded = versionNeeded;
    }

    public short getVersionNeeded() {
        return (short)Math.max(this.versionNeeded, Feature.getMinRequiredVersion(this.featureSet));
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void setFlag(Flag flag, boolean set) {
        int mask = 0;
        mask = (short)(mask | 1 << flag.getBit());
        this.flags = set ? (short)(this.flags | mask) : (short)(this.flags & ~mask);
    }

    public short getFlags() {
        return this.flags;
    }

    public void setInternalAttributes(short internalAttributes) {
        this.internalAttributes = internalAttributes;
    }

    public short getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setExternalAttributes(int externalAttributes) {
        this.externalAttributes = externalAttributes;
    }

    public int getExternalAttributes() {
        return this.externalAttributes;
    }

    void setLocalHeaderOffset(long localHeaderOffset) {
        if (localHeaderOffset < 0L) {
            throw new IllegalArgumentException("invalid local header offset");
        }
        if (localHeaderOffset > 0xFFFFFFFFL) {
            this.featureSet.add(Feature.ZIP64_OFFSET);
        } else {
            this.featureSet.remove((Object)Feature.ZIP64_OFFSET);
        }
        this.localHeaderOffset = localHeaderOffset;
    }

    public long getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    public void setExtra(ExtraDataList extra) {
        Preconditions.checkArgument((extra != null ? 1 : 0) != 0, (Object)"Zip file data could not be null");
        if (extra.getLength() > 65535) {
            throw new IllegalArgumentException("invalid extra field length");
        }
        this.extra = extra;
    }

    public ExtraDataList getExtra() {
        return this.extra;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    EnumSet<Feature> getFeatureSet() {
        return this.featureSet;
    }

    public String toString() {
        return "ZipFileEntry[" + this.name + "]";
    }

    static enum Feature {
        DEFAULT(10),
        STORED(10),
        DEFLATED(20),
        ZIP64_SIZE(45),
        ZIP64_CSIZE(45),
        ZIP64_OFFSET(45);

        private short minVersion;

        private Feature(short minVersion) {
            this.minVersion = minVersion;
        }

        public short getMinVersion() {
            return this.minVersion;
        }

        static short getMinRequiredVersion(EnumSet<Feature> featureSet) {
            short minVersion = DEFAULT.getMinVersion();
            for (Feature feature : featureSet) {
                minVersion = (short)Math.max(minVersion, feature.getMinVersion());
            }
            return minVersion;
        }
    }

    public static enum Flag {
        DATA_DESCRIPTOR(3);

        private int bit;

        private Flag(int bit) {
            this.bit = bit;
        }

        public int getBit() {
            return this.bit;
        }
    }

    public static enum Compression {
        STORED(0, Feature.STORED),
        DEFLATED(8, Feature.DEFLATED);

        private short value;
        private Feature feature;

        public static Compression fromValue(int value) {
            for (Compression c : Compression.values()) {
                if (c.getValue() != value) continue;
                return c;
            }
            return null;
        }

        private Compression(short value, Feature feature) {
            this.value = value;
            this.feature = feature;
        }

        public short getValue() {
            return this.value;
        }

        public short getMinVersion() {
            return this.feature.getMinVersion();
        }

        Feature getFeature() {
            return this.feature;
        }
    }
}

