/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class DruidConfig {
    private String coordinatorUrl;
    private String brokerUrl;
    private String schema = "druid";
    private boolean pushdown;
    private List<String> hadoopConfiguration = ImmutableList.of();
    private DruidAuthenticationType druidAuthenticationType = DruidAuthenticationType.NONE;
    private String basicAuthenticationUsername;
    private String basicAuthenticationPassword;
    private String ingestionStoragePath = StandardSystemProperty.JAVA_IO_TMPDIR.value();

    @NotNull
    public String getDruidCoordinatorUrl() {
        return this.coordinatorUrl;
    }

    @Config(value="druid.coordinator-url")
    @ConfigDescription(value="druid coordinator Url")
    public DruidConfig setDruidCoordinatorUrl(String coordinatorUrl) {
        this.coordinatorUrl = coordinatorUrl;
        return this;
    }

    @NotNull
    public String getDruidBrokerUrl() {
        return this.brokerUrl;
    }

    @Config(value="druid.broker-url")
    @ConfigDescription(value="druid broker Url")
    public DruidConfig setDruidBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
        return this;
    }

    @NotNull
    public String getDruidSchema() {
        return this.schema;
    }

    @Config(value="druid.schema-name")
    @ConfigDescription(value="druid schema name")
    public DruidConfig setDruidSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public boolean isComputePushdownEnabled() {
        return this.pushdown;
    }

    @Config(value="druid.compute-pushdown-enabled")
    @ConfigDescription(value="pushdown query processing to druid")
    public DruidConfig setComputePushdownEnabled(boolean pushdown) {
        this.pushdown = pushdown;
        return this;
    }

    @NotNull
    public List<String> getHadoopConfiguration() {
        return this.hadoopConfiguration;
    }

    public Configuration readHadoopConfiguration() {
        Configuration configuration = new Configuration(false);
        if (this.hadoopConfiguration.isEmpty()) {
            configuration.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            configuration.set("fs.file.impl", LocalFileSystem.class.getName());
        }
        for (String resourcePath : this.hadoopConfiguration) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            for (Map.Entry entry : resourceProperties) {
                configuration.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return configuration;
    }

    @Config(value="druid.hadoop.config.resources")
    public DruidConfig setHadoopConfiguration(String files) {
        if (files != null) {
            this.hadoopConfiguration = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        }
        return this;
    }

    public DruidConfig setHadoopConfiguration(List<String> files) {
        if (files != null) {
            this.hadoopConfiguration = ImmutableList.copyOf(files);
        }
        return this;
    }

    @NotNull
    public DruidAuthenticationType getDruidAuthenticationType() {
        return this.druidAuthenticationType;
    }

    @Config(value="druid.authentication.type")
    public DruidConfig setDruidAuthenticationType(DruidAuthenticationType druidAuthenticationType) {
        if (druidAuthenticationType != null) {
            this.druidAuthenticationType = druidAuthenticationType;
        }
        return this;
    }

    @Nullable
    public String getBasicAuthenticationUsername() {
        return this.basicAuthenticationUsername;
    }

    @Config(value="druid.basic.authentication.username")
    public DruidConfig setBasicAuthenticationUsername(String basicAuthenticationUsername) {
        this.basicAuthenticationUsername = basicAuthenticationUsername;
        return this;
    }

    @Nullable
    public String getBasicAuthenticationPassword() {
        return this.basicAuthenticationPassword;
    }

    @Config(value="druid.basic.authentication.password")
    public DruidConfig setBasicAuthenticationPassword(String basicAuthenticationPassword) {
        this.basicAuthenticationPassword = basicAuthenticationPassword;
        return this;
    }

    @Nullable
    public String getIngestionStoragePath() {
        return this.ingestionStoragePath;
    }

    @Config(value="druid.ingestion.storage.path")
    public DruidConfig setIngestionStoragePath(String ingestionStoragePath) {
        this.ingestionStoragePath = ingestionStoragePath;
        return this;
    }

    public static enum DruidAuthenticationType {
        NONE,
        BASIC,
        KERBEROS;

    }
}

