/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.druid.DruidConfig;
import com.facebook.presto.druid.DruidErrorCode;
import com.facebook.presto.druid.DruidResultFormat;
import com.facebook.presto.druid.ForDruidClient;
import com.facebook.presto.druid.ingestion.DruidIngestTask;
import com.facebook.presto.druid.metadata.DruidColumnInfo;
import com.facebook.presto.druid.metadata.DruidSegmentIdWrapper;
import com.facebook.presto.druid.metadata.DruidSegmentInfo;
import com.facebook.presto.druid.metadata.DruidTableInfo;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class DruidClient {
    private static final String METADATA_PATH = "/druid/coordinator/v1/metadata";
    private static final String SQL_ENDPOINT = "/druid/v2/sql";
    private static final String INDEXER_TASK_ENDPOINT = "/druid/indexer/v1/task";
    private static final String APPLICATION_JSON = "application/json";
    private static final String LIST_TABLE_QUERY = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'druid'";
    private static final String GET_COLUMN_TEMPLATE = "SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'druid' AND TABLE_NAME = '%s'";
    private static final String GET_SEGMENTS_ID_TEMPLATE = "SELECT segment_id FROM sys.segments WHERE datasource = '%s' AND is_published = 1";
    private static final JsonCodec<List<DruidSegmentIdWrapper>> LIST_SEGMENT_ID_CODEC = JsonCodec.listJsonCodec(DruidSegmentIdWrapper.class);
    private static final JsonCodec<List<DruidColumnInfo>> LIST_COLUMN_INFO_CODEC = JsonCodec.listJsonCodec(DruidColumnInfo.class);
    private static final JsonCodec<List<DruidTableInfo>> LIST_TABLE_NAME_CODEC = JsonCodec.listJsonCodec(DruidTableInfo.class);
    private static final JsonCodec<DruidSegmentInfo> SEGMENT_INFO_CODEC = JsonCodec.jsonCodec(DruidSegmentInfo.class);
    private final HttpClient httpClient;
    private final URI druidCoordinator;
    private final URI druidBroker;
    private final String druidSchema;

    @Inject
    public DruidClient(DruidConfig config, @ForDruidClient HttpClient httpClient) {
        Objects.requireNonNull(config, "config is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.druidCoordinator = URI.create(config.getDruidCoordinatorUrl());
        this.druidBroker = URI.create(config.getDruidBrokerUrl());
        this.druidSchema = config.getDruidSchema();
    }

    public URI getDruidBroker() {
        return this.druidBroker;
    }

    public String getSchema() {
        return this.druidSchema;
    }

    public List<String> getSchemas() {
        return ImmutableList.of((Object)this.druidSchema);
    }

    public List<String> getTables() {
        return (List)((List)this.httpClient.execute(this.prepareMetadataQuery(LIST_TABLE_QUERY), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_TABLE_NAME_CODEC))).stream().map(DruidTableInfo::getTableName).collect(ImmutableList.toImmutableList());
    }

    public List<DruidColumnInfo> getColumnDataType(String tableName) {
        return (List)this.httpClient.execute(this.prepareMetadataQuery(String.format(GET_COLUMN_TEMPLATE, tableName)), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_COLUMN_INFO_CODEC));
    }

    public List<String> getDataSegmentId(String tableName) {
        return (List)((List)this.httpClient.execute(this.prepareMetadataQuery(String.format(GET_SEGMENTS_ID_TEMPLATE, tableName)), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(LIST_SEGMENT_ID_CODEC))).stream().map(wrapper -> wrapper.getSegmentId()).collect(ImmutableList.toImmutableList());
    }

    public DruidSegmentInfo getSingleSegmentInfo(String dataSource, String segmentId) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.druidCoordinator).replacePath(METADATA_PATH).appendPath(String.format("datasources/%s/segments/%s", dataSource, segmentId)).build();
        Request request = DruidClient.setContentTypeHeaders(Request.Builder.prepareGet()).setUri(uri).build();
        return (DruidSegmentInfo)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(SEGMENT_INFO_CODEC));
    }

    public InputStream getData(String dql) {
        return (InputStream)this.httpClient.execute(this.prepareDataQuery(dql), (ResponseHandler)new StreamingJsonResponseHandler());
    }

    public InputStream ingestData(DruidIngestTask ingestTask) {
        return (InputStream)this.httpClient.execute(this.prepareDataIngestion(ingestTask), (ResponseHandler)new StreamingJsonResponseHandler());
    }

    private static Request.Builder setContentTypeHeaders(Request.Builder requestBuilder) {
        return requestBuilder.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
    }

    private static byte[] createRequestBody(String query, DruidResultFormat resultFormat, boolean queryHeader) {
        return new DruidRequestBody(query, resultFormat.getResultFormat(), queryHeader).toJson().getBytes();
    }

    private Request prepareMetadataQuery(String query) {
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)this.druidBroker).replacePath(SQL_ENDPOINT);
        return DruidClient.setContentTypeHeaders(Request.Builder.preparePost()).setUri(uriBuilder.build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])DruidClient.createRequestBody(query, DruidResultFormat.OBJECT, false))).build();
    }

    private Request prepareDataQuery(String query) {
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)this.druidBroker).replacePath(SQL_ENDPOINT);
        return DruidClient.setContentTypeHeaders(Request.Builder.preparePost()).setUri(uriBuilder.build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])DruidClient.createRequestBody(query, DruidResultFormat.OBJECT_LINES, false))).build();
    }

    private Request prepareDataIngestion(DruidIngestTask ingestTask) {
        HttpUriBuilder uriBuilder = HttpUriBuilder.uriBuilderFrom((URI)this.druidCoordinator).replacePath(INDEXER_TASK_ENDPOINT);
        return DruidClient.setContentTypeHeaders(Request.Builder.preparePost()).setUri(uriBuilder.build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])ingestTask.toJson().getBytes())).build();
    }

    public static class DruidRequestBody {
        private String query;
        private String resultFormat;
        private boolean queryHeader;

        @JsonCreator
        public DruidRequestBody(@JsonProperty(value="query") String query, @JsonProperty(value="resultFormat") String resultFormat, @JsonProperty(value="queryHeader") boolean queryHeader) {
            this.query = Objects.requireNonNull(query);
            this.resultFormat = Objects.requireNonNull(resultFormat);
            this.queryHeader = queryHeader;
        }

        @JsonProperty(value="query")
        public String getQuery() {
            return this.query;
        }

        @JsonProperty(value="resultFormat")
        public String getResultFormat() {
            return this.resultFormat;
        }

        @JsonProperty(value="queryHeader")
        public boolean isQueryHeader() {
            return this.queryHeader;
        }

        public String toJson() {
            return JsonCodec.jsonCodec(DruidRequestBody.class).toJson((Object)this);
        }
    }

    private static class StreamingJsonResponseHandler
    implements ResponseHandler<InputStream, RuntimeException> {
        private StreamingJsonResponseHandler() {
        }

        public InputStream handleException(Request request, Exception exception) {
            throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, "Request to worker failed", (Throwable)exception);
        }

        public InputStream handle(Request request, Response response) {
            try {
                if (response.getStatusCode() != 200) {
                    String result = new BufferedReader(new InputStreamReader(response.getInputStream())).lines().collect(Collectors.joining("\n"));
                    throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, result);
                }
                if (DruidClient.APPLICATION_JSON.equals(response.getHeader("Content-Type"))) {
                    return response.getInputStream();
                }
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, "Response received was not of type application/json");
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)DruidErrorCode.DRUID_BROKER_RESULT_ERROR, "Unable to read response from worker", (Throwable)e);
            }
        }
    }
}

