/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.druid.zip;

import com.facebook.presto.druid.zip.ZipUtil;
import java.util.Arrays;

final class ExtraData {
    static final int ID_OFFSET = 0;
    static final int LENGTH_OFFSET = 2;
    static final int FIXED_DATA_SIZE = 4;
    private final int index;
    private final byte[] buffer;

    public ExtraData(byte[] buffer, int index) {
        if (index >= buffer.length) {
            throw new IllegalArgumentException("index past end of buffer");
        }
        if (buffer.length - index < 4) {
            throw new IllegalArgumentException("incomplete extra data entry in buffer");
        }
        int length = ZipUtil.getUnsignedShort(buffer, index + 2);
        if (buffer.length - index - 4 < length) {
            throw new IllegalArgumentException("incomplete extra data entry in buffer");
        }
        this.buffer = buffer;
        this.index = index;
    }

    public short getId() {
        return ZipUtil.get16(this.buffer, this.index + 0);
    }

    public int getLength() {
        return ZipUtil.getUnsignedShort(this.buffer, this.index + 2) + 4;
    }

    public byte[] getData() {
        return Arrays.copyOfRange(this.buffer, this.index + 4, this.index + this.getLength());
    }

    public byte getByte(int index) {
        return this.buffer[this.index + index];
    }
}

