/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.Result;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.search.AllSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.search.SearchSortSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;

public class SearchQuery
extends BaseQuery<Result<SearchResultValue>> {
    private static final SearchSortSpec DEFAULT_SORT_SPEC = new SearchSortSpec(StringComparators.LEXICOGRAPHIC);
    private final DimFilter dimFilter;
    private final SearchSortSpec sortSpec;
    private final List<DimensionSpec> dimensions;
    private final SearchQuerySpec querySpec;
    private final int limit;

    @JsonCreator
    public SearchQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") Granularity granularity, @JsonProperty(value="limit") int limit, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="searchDimensions") List<DimensionSpec> dimensions, @JsonProperty(value="query") SearchQuerySpec querySpec, @JsonProperty(value="sort") SearchSortSpec sortSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context, Granularities.nullToAll((Granularity)granularity));
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"Must specify an interval");
        this.dimFilter = dimFilter;
        this.sortSpec = sortSpec == null ? DEFAULT_SORT_SPEC : sortSpec;
        this.limit = limit == 0 ? 1000 : limit;
        this.dimensions = dimensions;
        this.querySpec = querySpec == null ? new AllSearchQuerySpec() : querySpec;
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public DimFilter getFilter() {
        return this.dimFilter;
    }

    @Override
    public String getType() {
        return "search";
    }

    public SearchQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return Druids.SearchQueryBuilder.copy(this).intervals(spec).build();
    }

    @Override
    public Query<Result<SearchResultValue>> withDataSource(DataSource dataSource) {
        return Druids.SearchQueryBuilder.copy(this).dataSource(dataSource).build();
    }

    public SearchQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        Map<String, Object> newContext = SearchQuery.computeOverriddenContext(this.getContext(), contextOverrides);
        return Druids.SearchQueryBuilder.copy(this).context(newContext).build();
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="searchDimensions")
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getQuery() {
        return this.querySpec;
    }

    @JsonProperty(value="sort")
    public SearchSortSpec getSort() {
        return this.sortSpec;
    }

    public SearchQuery withLimit(int newLimit) {
        return Druids.SearchQueryBuilder.copy(this).limit(newLimit).build();
    }

    public String toString() {
        return "SearchQuery{dataSource='" + this.getDataSource() + '\'' + ", dimFilter=" + this.dimFilter + ", granularity='" + this.getGranularity() + '\'' + ", dimensions=" + this.dimensions + ", querySpec=" + this.querySpec + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", limit=" + this.limit + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchQuery that = (SearchQuery)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) {
            return false;
        }
        if (this.querySpec != null ? !this.querySpec.equals(that.querySpec) : that.querySpec != null) {
            return false;
        }
        return !(this.sortSpec != null ? !this.sortSpec.equals(that.sortSpec) : that.sortSpec != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.sortSpec != null ? this.sortSpec.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.querySpec != null ? this.querySpec.hashCode() : 0);
        result = 31 * result + this.limit;
        return result;
    }
}

