/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ColumnProcessors {
    public static <T> T makeProcessor(String column, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> factory.getColumnCapabilities(column)), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> factory.makeDimensionSelector(DefaultDimensionSpec.of(column))), factory -> factory.makeColumnValueSelector(column), processorFactory, selectorFactory);
    }

    public static <T> T makeProcessor(DimensionSpec dimensionSpec, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> {
            ColumnCapabilities dimensionCapabilities = factory.getColumnCapabilities(dimensionSpec.getDimension());
            if (dimensionSpec.getExtractionFn() != null || dimensionSpec.mustDecorate()) {
                return new ColumnCapabilitiesImpl().setType(ValueType.STRING).setDictionaryValuesSorted(dimensionSpec.getExtractionFn().preservesOrdering()).setDictionaryValuesUnique(dimensionSpec.getExtractionFn().getExtractionType() == ExtractionFn.ExtractionType.ONE_TO_ONE).setHasMultipleValues(dimensionSpec.mustDecorate() || ColumnProcessors.mayBeMultiValue(dimensionCapabilities));
            }
            return dimensionCapabilities;
        }), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> factory.makeDimensionSelector(dimensionSpec)), factory -> factory.makeColumnValueSelector(dimensionSpec.getDimension()), processorFactory, selectorFactory);
    }

    public static <T> T makeProcessor(Expr expr, ValueType exprTypeHint, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        Preconditions.checkNotNull((Object)((Object)exprTypeHint), (Object)"'exprTypeHint' must be nonnull");
        if (expr.getBindingIfIdentifier() != null) {
            return ColumnProcessors.makeProcessor(expr.getBindingIfIdentifier(), processorFactory, selectorFactory);
        }
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> new ColumnCapabilitiesImpl().setType(exprTypeHint).setHasMultipleValues(true).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false)), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> ExpressionSelectors.makeDimensionSelector(factory, expr, null)), factory -> ExpressionSelectors.makeColumnValueSelector(factory, expr), processorFactory, selectorFactory);
    }

    private static <T> T makeProcessorInternal(Function<ColumnSelectorFactory, ColumnCapabilities> inputCapabilitiesFn, Function<ColumnSelectorFactory, DimensionSelector> dimensionSelectorFn, Function<ColumnSelectorFactory, ColumnValueSelector<?>> valueSelectorFunction, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = (ColumnCapabilities)inputCapabilitiesFn.apply((Object)selectorFactory);
        ValueType effectiveType = capabilities != null ? capabilities.getType() : processorFactory.defaultType();
        switch (effectiveType) {
            case STRING: {
                return processorFactory.makeDimensionProcessor((DimensionSelector)dimensionSelectorFn.apply((Object)selectorFactory), ColumnProcessors.mayBeMultiValue(capabilities));
            }
            case LONG: {
                return processorFactory.makeLongProcessor((BaseLongColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case FLOAT: {
                return processorFactory.makeFloatProcessor((BaseFloatColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case DOUBLE: {
                return processorFactory.makeDoubleProcessor((BaseDoubleColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case COMPLEX: {
                return processorFactory.makeComplexProcessor((BaseObjectColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
        }
        throw new ISE("Unsupported type[%s]", new Object[]{effectiveType});
    }

    private static boolean mayBeMultiValue(@Nullable ColumnCapabilities capabilities) {
        return capabilities == null || capabilities.hasMultipleValues().isMaybeTrue();
    }
}

