/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.ByteBufferInputRowParser;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.Parser;

public class StringInputRowParser
implements ByteBufferInputRowParser {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final ParseSpec parseSpec;
    private final MapInputRowParser mapParser;
    private final Charset charset;
    private Parser<String, Object> parser;
    private CharBuffer chars;

    @JsonCreator
    public StringInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="encoding") String encoding) {
        this.parseSpec = (ParseSpec)Preconditions.checkNotNull((Object)parseSpec, (Object)"parseSpec");
        this.mapParser = new MapInputRowParser(parseSpec);
        this.charset = encoding != null ? Charset.forName(encoding) : DEFAULT_CHARSET;
    }

    @Deprecated
    public StringInputRowParser(ParseSpec parseSpec) {
        this(parseSpec, null);
    }

    @Override
    public List<InputRow> parseBatch(ByteBuffer input) {
        return Utils.nullableListOf(this.parseMap(this.buildStringKeyMap(input)));
    }

    @Override
    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public String getEncoding() {
        return this.charset.name();
    }

    @Override
    public StringInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new StringInputRowParser(parseSpec, this.getEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        Map<String, Object> theMap;
        CoderResult coderResult;
        int payloadSize = input.remaining();
        if (this.chars == null || this.chars.remaining() < payloadSize) {
            this.chars = CharBuffer.allocate(payloadSize);
        }
        if ((coderResult = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(input, this.chars, true)).isUnderflow()) {
            this.chars.flip();
            try {
                theMap = this.parseString(this.chars.toString());
            }
            finally {
                this.chars.clear();
            }
        } else {
            throw new ParseException("Failed with CoderResult[%s]", coderResult);
        }
        return theMap;
    }

    public void initializeParser() {
        if (this.parser == null) {
            this.parser = this.parseSpec.makeParser();
        }
    }

    public void startFileFromBeginning() {
        this.initializeParser();
        this.parser.startFileFromBeginning();
    }

    @Override
    @Nullable
    public InputRow parse(@Nullable String input) {
        return this.parseMap(this.parseString(input));
    }

    @Nullable
    public Map<String, Object> parseString(@Nullable String inputString) {
        this.initializeParser();
        return this.parser.parseToMap(inputString);
    }

    @Nullable
    private InputRow parseMap(@Nullable Map<String, Object> theMap) {
        if (theMap == null) {
            return null;
        }
        return (InputRow)Iterators.getOnlyElement(this.mapParser.parseBatch(theMap).iterator());
    }
}

