/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.impl.prefetch.FetchedFile;

public class OpenObject<T> {
    private final T object;
    private final InputStream objectStream;
    private final Closeable resourceCloser;

    public OpenObject(FetchedFile<T> fetchedFile) throws IOException {
        this(fetchedFile.getObject(), FileUtils.openInputStream((File)fetchedFile.getFile()), fetchedFile.getResourceCloser());
    }

    public OpenObject(T object, InputStream objectStream, Closeable resourceCloser) {
        this.object = object;
        this.objectStream = objectStream;
        this.resourceCloser = resourceCloser;
    }

    public T getObject() {
        return this.object;
    }

    public InputStream getObjectStream() {
        return this.objectStream;
    }

    public Closeable getResourceCloser() {
        return this.resourceCloser;
    }
}

