/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Function;

class FunctionExpr
implements Expr {
    final Function function;
    final ImmutableList<Expr> args;
    private final String name;

    FunctionExpr(Function function, String name, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.args = ImmutableList.copyOf(args);
        function.validateArguments(args);
    }

    public String toString() {
        return StringUtils.format("(%s %s)", this.name, this.args);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply((List<Expr>)this.args, bindings);
    }

    @Override
    public String stringify() {
        return StringUtils.format("%s(%s)", this.name, ARG_JOINER.join(this.args.stream().map(Expr::stringify).iterator()));
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        for (Expr child : this.args) {
            child.visit(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        List<Expr> newArgs = this.args.stream().map(shuttle::visit).collect(Collectors.toList());
        return shuttle.visit(new FunctionExpr(this.function, this.name, newArgs));
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        Expr.BindingDetails accumulator = new Expr.BindingDetails();
        for (Expr arg : this.args) {
            accumulator = accumulator.with(arg);
        }
        return accumulator.withScalarArguments(this.function.getScalarInputs((List<Expr>)this.args)).withArrayArguments(this.function.getArrayInputs((List<Expr>)this.args)).withArrayInputs(this.function.hasArrayInputs()).withArrayOutput(this.function.hasArrayOutput());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpr that = (FunctionExpr)o;
        return this.args.equals(that.args) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.name);
    }
}

