/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.math.expr.Expr;

abstract class UnaryExpr
implements Expr {
    final Expr expr;

    UnaryExpr(Expr expr) {
        this.expr = expr;
    }

    abstract UnaryExpr copy(Expr var1);

    @Override
    public void visit(Expr.Visitor visitor) {
        this.expr.visit(visitor);
        visitor.visit(this);
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        Expr newExpr = this.expr.visit(shuttle);
        if (newExpr != this.expr) {
            return shuttle.visit(this.copy(newExpr));
        }
        return shuttle.visit(this);
    }

    @Override
    public Expr.BindingDetails analyzeInputs() {
        return this.expr.analyzeInputs().withScalarArguments((Set<Expr>)ImmutableSet.of((Object)this.expr));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)o;
        return Objects.equals(this.expr, unaryExpr.expr);
    }

    public int hashCode() {
        return Objects.hash(this.expr);
    }
}

