/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;

public class RangeBucketShardSpec
implements BucketNumberedShardSpec<BuildingSingleDimensionShardSpec> {
    public static final String TYPE = "bucket_single_dim";
    private final int bucketId;
    private final String dimension;
    @Nullable
    private final String start;
    @Nullable
    private final String end;

    @JsonCreator
    public RangeBucketShardSpec(@JsonProperty(value="bucketId") int bucketId, @JsonProperty(value="dimension") String dimension, @JsonProperty(value="start") @Nullable String start, @JsonProperty(value="end") @Nullable String end) {
        this.bucketId = bucketId;
        this.dimension = dimension;
        this.start = start;
        this.end = end;
    }

    @Override
    @JsonProperty
    public int getBucketId() {
        return this.bucketId;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Nullable
    @JsonProperty
    public String getStart() {
        return this.start;
    }

    @Nullable
    @JsonProperty
    public String getEnd() {
        return this.end;
    }

    @Override
    public BuildingSingleDimensionShardSpec convert(int partitionId) {
        return new BuildingSingleDimensionShardSpec(this.bucketId, this.dimension, this.start, this.end, partitionId);
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return SingleDimensionShardSpec.isInChunk(this.dimension, this.start, this.end, inputRow);
    }

    @Override
    public ShardSpecLookup getLookup(List<? extends ShardSpec> shardSpecs) {
        return SingleDimensionShardSpec.createLookup(shardSpecs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeBucketShardSpec bucket = (RangeBucketShardSpec)o;
        return this.bucketId == bucket.bucketId && Objects.equals(this.dimension, bucket.dimension) && Objects.equals(this.start, bucket.start) && Objects.equals(this.end, bucket.end);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.dimension, this.start, this.end);
    }

    public String toString() {
        return "RangeBucket{, bucketId=" + this.bucketId + ", dimension='" + this.dimension + '\'' + ", start='" + this.start + '\'' + ", end='" + this.end + '\'' + '}';
    }
}

