/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.guice;

import com.facebook.drift.codec.InternalThriftCodec;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ForCompiler;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import java.util.Objects;

public class ThriftCodecModule
implements Module {
    private final ClassLoader parent;

    public ThriftCodecModule() {
        this(ThriftCodecModule.class.getClassLoader());
    }

    public ThriftCodecModule(ClassLoader parent) {
        this.parent = parent;
    }

    public void configure(Binder binder) {
        binder.bind(ThriftCodecFactory.class).to(CompilerThriftCodecFactory.class).in(Scopes.SINGLETON);
        binder.bind(ThriftCatalog.class).in(Scopes.SINGLETON);
        binder.bind(ThriftCodecManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<ThriftCodec<?>>(){}, InternalThriftCodec.class).permitDuplicates();
        binder.bind(ClassLoader.class).annotatedWith(ForCompiler.class).toInstance((Object)this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThriftCodecModule that = (ThriftCodecModule)o;
        return Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }
}

